@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetEventSourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEventSource.
 * @property namePrefix Specifying this limits the results to only those partner event sources with names that start with the specified prefix
 */
public data class GetEventSourcePlainArgs(
    public val namePrefix: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetEventSourcePlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.GetEventSourcePlainArgs =
        com.pulumi.aws.cloudwatch.inputs.GetEventSourcePlainArgs.builder()
            .namePrefix(namePrefix?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEventSourcePlainArgs].
 */
@PulumiTagMarker
public class GetEventSourcePlainArgsBuilder internal constructor() {
    private var namePrefix: String? = null

    /**
     * @param value Specifying this limits the results to only those partner event sources with names that start with the specified prefix
     */
    @JvmName("nweiaeeyskqlchnq")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namePrefix = mapped
    }

    internal fun build(): GetEventSourcePlainArgs = GetEventSourcePlainArgs(
        namePrefix = namePrefix,
    )
}
