@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLogDataProtectionPolicyDocument.
 * @property description
 * @property name The name of the data protection policy document.
 * @property statements Configures the data protection policy.
 * > There must be exactly two statements: the first with an `audit` operation, and the second with a `deidentify` operation.
 * The following arguments are optional:
 * @property version
 */
public data class GetLogDataProtectionPolicyDocumentPlainArgs(
    public val description: String? = null,
    public val name: String,
    public val statements: List<GetLogDataProtectionPolicyDocumentStatement>,
    public val version: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentPlainArgs =
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentPlainArgs.builder()
            .description(description?.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .statements(statements.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .version(version?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogDataProtectionPolicyDocumentPlainArgs].
 */
@PulumiTagMarker
public class GetLogDataProtectionPolicyDocumentPlainArgsBuilder internal constructor() {
    private var description: String? = null

    private var name: String? = null

    private var statements: List<GetLogDataProtectionPolicyDocumentStatement>? = null

    private var version: String? = null

    /**
     * @param value
     */
    @JvmName("ayqkovvyclqrumwc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value The name of the data protection policy document.
     */
    @JvmName("tkttcnhgrfuhntja")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Configures the data protection policy.
     * > There must be exactly two statements: the first with an `audit` operation, and the second with a `deidentify` operation.
     * The following arguments are optional:
     */
    @JvmName("fyhvwxoopngguchq")
    public suspend fun statements(`value`: List<GetLogDataProtectionPolicyDocumentStatement>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statements = mapped
    }

    /**
     * @param argument Configures the data protection policy.
     * > There must be exactly two statements: the first with an `audit` operation, and the second with a `deidentify` operation.
     * The following arguments are optional:
     */
    @JvmName("elnmepirnoibexsv")
    public suspend fun statements(argument: List<suspend GetLogDataProtectionPolicyDocumentStatementBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetLogDataProtectionPolicyDocumentStatementBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.statements = mapped
    }

    /**
     * @param argument Configures the data protection policy.
     * > There must be exactly two statements: the first with an `audit` operation, and the second with a `deidentify` operation.
     * The following arguments are optional:
     */
    @JvmName("jdpdlscpsowslygq")
    public suspend fun statements(vararg argument: suspend GetLogDataProtectionPolicyDocumentStatementBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetLogDataProtectionPolicyDocumentStatementBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.statements = mapped
    }

    /**
     * @param argument Configures the data protection policy.
     * > There must be exactly two statements: the first with an `audit` operation, and the second with a `deidentify` operation.
     * The following arguments are optional:
     */
    @JvmName("nwlopoippplqmjbl")
    public suspend fun statements(argument: suspend GetLogDataProtectionPolicyDocumentStatementBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetLogDataProtectionPolicyDocumentStatementBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.statements = mapped
    }

    /**
     * @param values Configures the data protection policy.
     * > There must be exactly two statements: the first with an `audit` operation, and the second with a `deidentify` operation.
     * The following arguments are optional:
     */
    @JvmName("ohsgdbyqstjwohlj")
    public suspend fun statements(vararg values: GetLogDataProtectionPolicyDocumentStatement) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.statements = mapped
    }

    /**
     * @param value
     */
    @JvmName("vgfgbopqjkpgyjgb")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.version = mapped
    }

    internal fun build(): GetLogDataProtectionPolicyDocumentPlainArgs =
        GetLogDataProtectionPolicyDocumentPlainArgs(
            description = description,
            name = name ?: throw PulumiNullFieldException("name"),
            statements = statements ?: throw PulumiNullFieldException("statements"),
            version = version,
        )
}
