@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatement.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dataIdentifiers Set of at least 1 sensitive data identifiers that you want to mask. Read more in [Types of data that you can protect](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/protect-sensitive-log-data-types.html).
 * @property operation Configures the data protection operation applied by this statement.
 * @property sid Name of this statement.
 */
public data class GetLogDataProtectionPolicyDocumentStatement(
    public val dataIdentifiers: List<String>,
    public val operation: GetLogDataProtectionPolicyDocumentStatementOperation,
    public val sid: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatement> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatement =
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatement.builder()
            .dataIdentifiers(dataIdentifiers.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .operation(operation.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sid(sid?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogDataProtectionPolicyDocumentStatement].
 */
@PulumiTagMarker
public class GetLogDataProtectionPolicyDocumentStatementBuilder internal constructor() {
    private var dataIdentifiers: List<String>? = null

    private var operation: GetLogDataProtectionPolicyDocumentStatementOperation? = null

    private var sid: String? = null

    /**
     * @param value Set of at least 1 sensitive data identifiers that you want to mask. Read more in [Types of data that you can protect](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/protect-sensitive-log-data-types.html).
     */
    @JvmName("qbmmiioyhxggmiko")
    public suspend fun dataIdentifiers(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataIdentifiers = mapped
    }

    /**
     * @param values Set of at least 1 sensitive data identifiers that you want to mask. Read more in [Types of data that you can protect](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/protect-sensitive-log-data-types.html).
     */
    @JvmName("uqqehlkjksivglml")
    public suspend fun dataIdentifiers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataIdentifiers = mapped
    }

    /**
     * @param value Configures the data protection operation applied by this statement.
     */
    @JvmName("klppmckuwyijyjnr")
    public suspend fun operation(`value`: GetLogDataProtectionPolicyDocumentStatementOperation) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.operation = mapped
    }

    /**
     * @param argument Configures the data protection operation applied by this statement.
     */
    @JvmName("fomtgjvqyptfftys")
    public suspend fun operation(argument: suspend GetLogDataProtectionPolicyDocumentStatementOperationBuilder.() -> Unit) {
        val toBeMapped = GetLogDataProtectionPolicyDocumentStatementOperationBuilder().applySuspend {
            argument()
        }.build()
        val mapped = toBeMapped
        this.operation = mapped
    }

    /**
     * @param value Name of this statement.
     */
    @JvmName("qxlrvgrhiflqolpx")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sid = mapped
    }

    internal fun build(): GetLogDataProtectionPolicyDocumentStatement =
        GetLogDataProtectionPolicyDocumentStatement(
            dataIdentifiers = dataIdentifiers ?: throw PulumiNullFieldException("dataIdentifiers"),
            operation = operation ?: throw PulumiNullFieldException("operation"),
            sid = sid,
        )
}
