@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property logGroup Name of the CloudWatch Log Group to send findings to.
 */
public data class
GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs(
    public val logGroup: String,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs =
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs.builder()
            .logGroup(logGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs].
 */
@PulumiTagMarker
public class
GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogsBuilder
internal constructor() {
    private var logGroup: String? = null

    /**
     * @param value Name of the CloudWatch Log Group to send findings to.
     */
    @JvmName("xgqbjvlqpbbitxvm")
    public suspend fun logGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.logGroup = mapped
    }

    internal fun build(): GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs =
        GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationCloudwatchLogs(
            logGroup = logGroup ?: throw PulumiNullFieldException("logGroup"),
        )
}
