@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property deliveryStream Name of the Kinesis Firehose Delivery Stream to send findings to.
 */
public data class
GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose(
    public val deliveryStream: String,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose =
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose.builder()
            .deliveryStream(deliveryStream.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose].
 */
@PulumiTagMarker
public class
GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehoseBuilder
internal constructor() {
    private var deliveryStream: String? = null

    /**
     * @param value Name of the Kinesis Firehose Delivery Stream to send findings to.
     */
    @JvmName("ujkayncyihavydxr")
    public suspend fun deliveryStream(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.deliveryStream = mapped
    }

    internal fun build(): GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose =
        GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationFirehose(
            deliveryStream = deliveryStream ?: throw PulumiNullFieldException("deliveryStream"),
        )
}
