@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucket Name of the S3 Bucket to send findings to.
 */
public data class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3(
    public val bucket: String,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3 =
        com.pulumi.aws.cloudwatch.inputs.GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3.builder()
            .bucket(bucket.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3].
 */
@PulumiTagMarker
public class GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3Builder
internal constructor() {
    private var bucket: String? = null

    /**
     * @param value Name of the S3 Bucket to send findings to.
     */
    @JvmName("ikxrbhcyjojdocun")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bucket = mapped
    }

    internal fun build(): GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3 =
        GetLogDataProtectionPolicyDocumentStatementOperationAuditFindingsDestinationS3(
            bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        )
}
