@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.GetLogGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getLogGroups.
 * @property logGroupNamePrefix Group prefix of the Cloudwatch log groups to list
 */
public data class GetLogGroupsPlainArgs(
    public val logGroupNamePrefix: String? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.GetLogGroupsPlainArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.GetLogGroupsPlainArgs =
        com.pulumi.aws.cloudwatch.inputs.GetLogGroupsPlainArgs.builder()
            .logGroupNamePrefix(logGroupNamePrefix?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLogGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetLogGroupsPlainArgsBuilder internal constructor() {
    private var logGroupNamePrefix: String? = null

    /**
     * @param value Group prefix of the Cloudwatch log groups to list
     */
    @JvmName("yhvybcvkhuqmbnrq")
    public suspend fun logGroupNamePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.logGroupNamePrefix = mapped
    }

    internal fun build(): GetLogGroupsPlainArgs = GetLogGroupsPlainArgs(
        logGroupNamePrefix = logGroupNamePrefix,
    )
}
