@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.InternetMonitorHealthEventsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property availabilityScoreThreshold The health event threshold percentage set for availability scores.
 * @property performanceScoreThreshold The health event threshold percentage set for performance scores.
 */
public data class InternetMonitorHealthEventsConfigArgs(
    public val availabilityScoreThreshold: Output<Double>? = null,
    public val performanceScoreThreshold: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.InternetMonitorHealthEventsConfigArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.InternetMonitorHealthEventsConfigArgs =
        com.pulumi.aws.cloudwatch.inputs.InternetMonitorHealthEventsConfigArgs.builder()
            .availabilityScoreThreshold(availabilityScoreThreshold?.applyValue({ args0 -> args0 }))
            .performanceScoreThreshold(performanceScoreThreshold?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InternetMonitorHealthEventsConfigArgs].
 */
@PulumiTagMarker
public class InternetMonitorHealthEventsConfigArgsBuilder internal constructor() {
    private var availabilityScoreThreshold: Output<Double>? = null

    private var performanceScoreThreshold: Output<Double>? = null

    /**
     * @param value The health event threshold percentage set for availability scores.
     */
    @JvmName("hskexoxnosbbyeai")
    public suspend fun availabilityScoreThreshold(`value`: Output<Double>) {
        this.availabilityScoreThreshold = value
    }

    /**
     * @param value The health event threshold percentage set for performance scores.
     */
    @JvmName("afosstcjrotbdcnr")
    public suspend fun performanceScoreThreshold(`value`: Output<Double>) {
        this.performanceScoreThreshold = value
    }

    /**
     * @param value The health event threshold percentage set for availability scores.
     */
    @JvmName("cxkusdfgqlgxfnmw")
    public suspend fun availabilityScoreThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityScoreThreshold = mapped
    }

    /**
     * @param value The health event threshold percentage set for performance scores.
     */
    @JvmName("pdnojyyxwbxvuiru")
    public suspend fun performanceScoreThreshold(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceScoreThreshold = mapped
    }

    internal fun build(): InternetMonitorHealthEventsConfigArgs =
        InternetMonitorHealthEventsConfigArgs(
            availabilityScoreThreshold = availabilityScoreThreshold,
            performanceScoreThreshold = performanceScoreThreshold,
        )
}
