@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.LogMetricFilterMetricTransformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property defaultValue The value to emit when a filter pattern does not match a log event. Conflicts with `dimensions`.
 * @property dimensions Map of fields to use as dimensions for the metric. Up to 3 dimensions are allowed. Conflicts with `default_value`.
 * @property name The name of the CloudWatch metric to which the monitored log information should be published (e.g., `ErrorCount`)
 * @property namespace The destination namespace of the CloudWatch metric.
 * @property unit The unit to assign to the metric. If you omit this, the unit is set as `None`.
 * @property value What to publish to the metric. For example, if you're counting the occurrences of a particular term like "Error", the value will be "1" for each occurrence. If you're counting the bytes transferred the published value will be the value in the log event.
 */
public data class LogMetricFilterMetricTransformationArgs(
    public val defaultValue: Output<String>? = null,
    public val dimensions: Output<Map<String, String>>? = null,
    public val name: Output<String>,
    public val namespace: Output<String>,
    public val unit: Output<String>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.LogMetricFilterMetricTransformationArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.LogMetricFilterMetricTransformationArgs =
        com.pulumi.aws.cloudwatch.inputs.LogMetricFilterMetricTransformationArgs.builder()
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 }))
            .dimensions(
                dimensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .name(name.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 }))
            .unit(unit?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LogMetricFilterMetricTransformationArgs].
 */
@PulumiTagMarker
public class LogMetricFilterMetricTransformationArgsBuilder internal constructor() {
    private var defaultValue: Output<String>? = null

    private var dimensions: Output<Map<String, String>>? = null

    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    private var unit: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The value to emit when a filter pattern does not match a log event. Conflicts with `dimensions`.
     */
    @JvmName("ttmkncpnpdlaxody")
    public suspend fun defaultValue(`value`: Output<String>) {
        this.defaultValue = value
    }

    /**
     * @param value Map of fields to use as dimensions for the metric. Up to 3 dimensions are allowed. Conflicts with `default_value`.
     */
    @JvmName("tjrhsyrybakxuolu")
    public suspend fun dimensions(`value`: Output<Map<String, String>>) {
        this.dimensions = value
    }

    /**
     * @param value The name of the CloudWatch metric to which the monitored log information should be published (e.g., `ErrorCount`)
     */
    @JvmName("otvlvslhbircwnog")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The destination namespace of the CloudWatch metric.
     */
    @JvmName("pyepaoejdfwgobjp")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The unit to assign to the metric. If you omit this, the unit is set as `None`.
     */
    @JvmName("sorbxbfmuxtqyais")
    public suspend fun unit(`value`: Output<String>) {
        this.unit = value
    }

    /**
     * @param value What to publish to the metric. For example, if you're counting the occurrences of a particular term like "Error", the value will be "1" for each occurrence. If you're counting the bytes transferred the published value will be the value in the log event.
     */
    @JvmName("dxouxneigbyrwlcc")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The value to emit when a filter pattern does not match a log event. Conflicts with `dimensions`.
     */
    @JvmName("kcfeetuukwnwvjyu")
    public suspend fun defaultValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    /**
     * @param value Map of fields to use as dimensions for the metric. Up to 3 dimensions are allowed. Conflicts with `default_value`.
     */
    @JvmName("fescodsywnopyejs")
    public suspend fun dimensions(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param values Map of fields to use as dimensions for the metric. Up to 3 dimensions are allowed. Conflicts with `default_value`.
     */
    @JvmName("wnyhhimmtjkikhxg")
    public fun dimensions(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dimensions = mapped
    }

    /**
     * @param value The name of the CloudWatch metric to which the monitored log information should be published (e.g., `ErrorCount`)
     */
    @JvmName("wmmjqegkaqvkahmf")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The destination namespace of the CloudWatch metric.
     */
    @JvmName("dnekbkrsfmbgweka")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The unit to assign to the metric. If you omit this, the unit is set as `None`.
     */
    @JvmName("bjishgisfpuvehbr")
    public suspend fun unit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.unit = mapped
    }

    /**
     * @param value What to publish to the metric. For example, if you're counting the occurrences of a particular term like "Error", the value will be "1" for each occurrence. If you're counting the bytes transferred the published value will be the value in the log event.
     */
    @JvmName("wbnpmsfjtisclckl")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): LogMetricFilterMetricTransformationArgs =
        LogMetricFilterMetricTransformationArgs(
            defaultValue = defaultValue,
            dimensions = dimensions,
            name = name ?: throw PulumiNullFieldException("name"),
            namespace = namespace ?: throw PulumiNullFieldException("namespace"),
            unit = unit,
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
