@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property accountId The ID of the account where the metrics are located, if this is a cross-account alarm.
 * @property expression The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the id of the other metrics to refer to those metrics, and can also use the id of other expressions to use the result of those expressions. For more information about metric math expressions, see Metric Math Syntax and Functions in the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax).
 * @property id A short name used to tie this object to the results in the response. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
 * @property label A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents.
 * @property metric The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
 * @property period Granularity in seconds of returned data points.
 * For metrics with regular resolution, valid values are any multiple of `60`.
 * For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
 * @property returnData Specify exactly one `metric_query` to be `true` to use that `metric_query` result as the alarm.
 * > **NOTE:**  You must specify either `metric` or `expression`. Not both.
 */
public data class MetricAlarmMetricQueryArgs(
    public val accountId: Output<String>? = null,
    public val expression: Output<String>? = null,
    public val id: Output<String>,
    public val label: Output<String>? = null,
    public val metric: Output<MetricAlarmMetricQueryMetricArgs>? = null,
    public val period: Output<Int>? = null,
    public val returnData: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryArgs =
        com.pulumi.aws.cloudwatch.inputs.MetricAlarmMetricQueryArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .expression(expression?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .metric(metric?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .period(period?.applyValue({ args0 -> args0 }))
            .returnData(returnData?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricAlarmMetricQueryArgs].
 */
@PulumiTagMarker
public class MetricAlarmMetricQueryArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var expression: Output<String>? = null

    private var id: Output<String>? = null

    private var label: Output<String>? = null

    private var metric: Output<MetricAlarmMetricQueryMetricArgs>? = null

    private var period: Output<Int>? = null

    private var returnData: Output<Boolean>? = null

    /**
     * @param value The ID of the account where the metrics are located, if this is a cross-account alarm.
     */
    @JvmName("errsbkisagrjswuu")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the id of the other metrics to refer to those metrics, and can also use the id of other expressions to use the result of those expressions. For more information about metric math expressions, see Metric Math Syntax and Functions in the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax).
     */
    @JvmName("oqiiruonijfueopc")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value A short name used to tie this object to the results in the response. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
     */
    @JvmName("nolnqfgcfbygxccd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents.
     */
    @JvmName("qcxobsriqrpntccg")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
     */
    @JvmName("kkbhlbowfycccssj")
    public suspend fun metric(`value`: Output<MetricAlarmMetricQueryMetricArgs>) {
        this.metric = value
    }

    /**
     * @param value Granularity in seconds of returned data points.
     * For metrics with regular resolution, valid values are any multiple of `60`.
     * For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
     */
    @JvmName("lmadhvlcdfaswnhc")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Specify exactly one `metric_query` to be `true` to use that `metric_query` result as the alarm.
     * > **NOTE:**  You must specify either `metric` or `expression`. Not both.
     */
    @JvmName("oderngdyegwimxdb")
    public suspend fun returnData(`value`: Output<Boolean>) {
        this.returnData = value
    }

    /**
     * @param value The ID of the account where the metrics are located, if this is a cross-account alarm.
     */
    @JvmName("xudkwdjxatghgfby")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The math expression to be performed on the returned data, if this object is performing a math expression. This expression can use the id of the other metrics to refer to those metrics, and can also use the id of other expressions to use the result of those expressions. For more information about metric math expressions, see Metric Math Syntax and Functions in the [Amazon CloudWatch User Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/using-metric-math.html#metric-math-syntax).
     */
    @JvmName("jpvpuxrpexdsmoig")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value A short name used to tie this object to the results in the response. If you are performing math expressions on this set of data, this name represents that data and can serve as a variable in the mathematical expression. The valid characters are letters, numbers, and underscore. The first character must be a lowercase letter.
     */
    @JvmName("bvrfoiwgflpfogle")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value A human-readable label for this metric or expression. This is especially useful if this is an expression, so that you know what the value represents.
     */
    @JvmName("dfrwajqkagdkhcnc")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
     */
    @JvmName("thgkiceapwcngbdm")
    public suspend fun metric(`value`: MetricAlarmMetricQueryMetricArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metric = mapped
    }

    /**
     * @param argument The metric to be returned, along with statistics, period, and units. Use this parameter only if this object is retrieving a metric and not performing a math expression on returned data.
     */
    @JvmName("yfvjwbbppqtqneye")
    public suspend fun metric(argument: suspend MetricAlarmMetricQueryMetricArgsBuilder.() -> Unit) {
        val toBeMapped = MetricAlarmMetricQueryMetricArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.metric = mapped
    }

    /**
     * @param value Granularity in seconds of returned data points.
     * For metrics with regular resolution, valid values are any multiple of `60`.
     * For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
     */
    @JvmName("agfehmboktvoyemo")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Specify exactly one `metric_query` to be `true` to use that `metric_query` result as the alarm.
     * > **NOTE:**  You must specify either `metric` or `expression`. Not both.
     */
    @JvmName("byknvgpxgyoadjky")
    public suspend fun returnData(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.returnData = mapped
    }

    internal fun build(): MetricAlarmMetricQueryArgs = MetricAlarmMetricQueryArgs(
        accountId = accountId,
        expression = expression,
        id = id ?: throw PulumiNullFieldException("id"),
        label = label,
        metric = metric,
        period = period,
        returnData = returnData,
    )
}
