@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.MetricStreamExcludeFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property metricNames An array that defines the metrics you want to exclude for this metric namespace
 * @property namespace Name of the metric namespace in the filter.
 */
public data class MetricStreamExcludeFilterArgs(
    public val metricNames: Output<List<String>>? = null,
    public val namespace: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.MetricStreamExcludeFilterArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.MetricStreamExcludeFilterArgs =
        com.pulumi.aws.cloudwatch.inputs.MetricStreamExcludeFilterArgs.builder()
            .metricNames(metricNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .namespace(namespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricStreamExcludeFilterArgs].
 */
@PulumiTagMarker
public class MetricStreamExcludeFilterArgsBuilder internal constructor() {
    private var metricNames: Output<List<String>>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value An array that defines the metrics you want to exclude for this metric namespace
     */
    @JvmName("ouqbqlbkuglcpako")
    public suspend fun metricNames(`value`: Output<List<String>>) {
        this.metricNames = value
    }

    @JvmName("fhiyfufbenxiymaf")
    public suspend fun metricNames(vararg values: Output<String>) {
        this.metricNames = Output.all(values.asList())
    }

    /**
     * @param values An array that defines the metrics you want to exclude for this metric namespace
     */
    @JvmName("vlocyptjascetdmx")
    public suspend fun metricNames(values: List<Output<String>>) {
        this.metricNames = Output.all(values)
    }

    /**
     * @param value Name of the metric namespace in the filter.
     */
    @JvmName("gmbqgnxxnokytbcb")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value An array that defines the metrics you want to exclude for this metric namespace
     */
    @JvmName("gbvcighugntnuaup")
    public suspend fun metricNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metricNames = mapped
    }

    /**
     * @param values An array that defines the metrics you want to exclude for this metric namespace
     */
    @JvmName("qalvxebchvexsdxt")
    public suspend fun metricNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricNames = mapped
    }

    /**
     * @param value Name of the metric namespace in the filter.
     */
    @JvmName("qfmffkdwygmiaxov")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): MetricStreamExcludeFilterArgs = MetricStreamExcludeFilterArgs(
        metricNames = metricNames,
        namespace = namespace ?: throw PulumiNullFieldException("namespace"),
    )
}
