@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.inputs

import com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationIncludeMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metricName The name of the metric.
 * @property namespace
 */
public data class MetricStreamStatisticsConfigurationIncludeMetricArgs(
    public val metricName: Output<String>,
    public val namespace: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationIncludeMetricArgs> {
    override fun toJava(): com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationIncludeMetricArgs =
        com.pulumi.aws.cloudwatch.inputs.MetricStreamStatisticsConfigurationIncludeMetricArgs.builder()
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricStreamStatisticsConfigurationIncludeMetricArgs].
 */
@PulumiTagMarker
public class MetricStreamStatisticsConfigurationIncludeMetricArgsBuilder internal constructor() {
    private var metricName: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value The name of the metric.
     */
    @JvmName("ptoxylpuvnjalrux")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value
     */
    @JvmName("olvaxxmytwoweqcu")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The name of the metric.
     */
    @JvmName("sfcjslfhnjnpyrnr")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value
     */
    @JvmName("yrxyrxscmeecxekc")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): MetricStreamStatisticsConfigurationIncludeMetricArgs =
        MetricStreamStatisticsConfigurationIncludeMetricArgs(
            metricName = metricName ?: throw PulumiNullFieldException("metricName"),
            namespace = namespace ?: throw PulumiNullFieldException("namespace"),
        )
}
