@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property password A password for the authorization. Created and stored in AWS Secrets Manager.
 * @property username A username for the authorization.
 */
public data class EventConnectionAuthParametersBasic(
    public val password: String,
    public val username: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventConnectionAuthParametersBasic): EventConnectionAuthParametersBasic = EventConnectionAuthParametersBasic(
            password = javaType.password(),
            username = javaType.username(),
        )
    }
}
