@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arraySize The size of the array, if this is an array batch job. Valid values are integers between 2 and 10,000.
 * @property jobAttempts The number of times to attempt to retry, if the job fails. Valid values are 1 to 10.
 * @property jobDefinition The ARN or name of the job definition to use if the event target is an AWS Batch job. This job definition must already exist.
 * @property jobName The name to use for this execution of the job, if the target is an AWS Batch job.
 */
public data class EventTargetBatchTarget(
    public val arraySize: Int? = null,
    public val jobAttempts: Int? = null,
    public val jobDefinition: String,
    public val jobName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetBatchTarget): EventTargetBatchTarget = EventTargetBatchTarget(
            arraySize = javaType.arraySize().map({ args0 -> args0 }).orElse(null),
            jobAttempts = javaType.jobAttempts().map({ args0 -> args0 }).orElse(null),
            jobDefinition = javaType.jobDefinition(),
            jobName = javaType.jobName(),
        )
    }
}
