@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property capacityProviderStrategies The capacity provider strategy to use for the task. If a `capacity_provider_strategy` specified, the `launch_type` parameter must be omitted. If no `capacity_provider_strategy` or `launch_type` is specified, the default capacity provider strategy for the cluster is used. Can be one or more. See below.
 * @property enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the task.
 * @property enableExecuteCommand Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.
 * @property group Specifies an ECS task group for the task. The maximum length is 255 characters.
 * @property launchType Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. Valid values include: `EC2`, `EXTERNAL`, or `FARGATE`.
 * @property networkConfiguration Use this if the ECS task uses the awsvpc network mode. This specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. Required if `launch_type` is `FARGATE` because the awsvpc mode is required for Fargate tasks.
 * @property orderedPlacementStrategies An array of placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task.
 * @property placementConstraints An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime). See Below.
 * @property platformVersion Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as `1.1.0`. This is used only if LaunchType is FARGATE. For more information about valid platform versions, see [AWS Fargate Platform Versions](http://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html).
 * @property propagateTags Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. The only valid value is: `TASK_DEFINITION`.
 * @property tags A map of tags to assign to ecs resources.
 * @property taskCount The number of tasks to create based on the TaskDefinition. Defaults to `1`.
 * @property taskDefinitionArn The ARN of the task definition to use if the event target is an Amazon ECS cluster.
 */
public data class EventTargetEcsTarget(
    public val capacityProviderStrategies: List<EventTargetEcsTargetCapacityProviderStrategy>? = null,
    public val enableEcsManagedTags: Boolean? = null,
    public val enableExecuteCommand: Boolean? = null,
    public val group: String? = null,
    public val launchType: String? = null,
    public val networkConfiguration: EventTargetEcsTargetNetworkConfiguration? = null,
    public val orderedPlacementStrategies: List<EventTargetEcsTargetOrderedPlacementStrategy>? = null,
    public val placementConstraints: List<EventTargetEcsTargetPlacementConstraint>? = null,
    public val platformVersion: String? = null,
    public val propagateTags: String? = null,
    public val tags: Map<String, String>? = null,
    public val taskCount: Int? = null,
    public val taskDefinitionArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetEcsTarget): EventTargetEcsTarget = EventTargetEcsTarget(
            capacityProviderStrategies = javaType.capacityProviderStrategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetEcsTargetCapacityProviderStrategy.Companion.toKotlin(args0)
                })
            }),
            enableEcsManagedTags = javaType.enableEcsManagedTags().map({ args0 -> args0 }).orElse(null),
            enableExecuteCommand = javaType.enableExecuteCommand().map({ args0 -> args0 }).orElse(null),
            group = javaType.group().map({ args0 -> args0 }).orElse(null),
            launchType = javaType.launchType().map({ args0 -> args0 }).orElse(null),
            networkConfiguration = javaType.networkConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetEcsTargetNetworkConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            orderedPlacementStrategies = javaType.orderedPlacementStrategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetEcsTargetOrderedPlacementStrategy.Companion.toKotlin(args0)
                })
            }),
            placementConstraints = javaType.placementConstraints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.EventTargetEcsTargetPlacementConstraint.Companion.toKotlin(args0)
                })
            }),
            platformVersion = javaType.platformVersion().map({ args0 -> args0 }).orElse(null),
            propagateTags = javaType.propagateTags().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            taskCount = javaType.taskCount().map({ args0 -> args0 }).orElse(null),
            taskDefinitionArn = javaType.taskDefinitionArn(),
        )
    }
}
