@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property field The field to apply the placement strategy against. For the `spread` placement strategy, valid values are `instanceId` (or `host`, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as `attribute:ecs.availability-zone`. For the `binpack` placement strategy, valid values are `cpu` and `memory`. For the `random` placement strategy, this field is not used. For more information, see [Amazon ECS task placement strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
 * @property type Type of placement strategy. The only valid values at this time are `binpack`, `random` and `spread`.
 */
public data class EventTargetEcsTargetOrderedPlacementStrategy(
    public val `field`: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetEcsTargetOrderedPlacementStrategy): EventTargetEcsTargetOrderedPlacementStrategy = EventTargetEcsTargetOrderedPlacementStrategy(
            `field` = javaType.`field`().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
