@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property expression Cluster Query Language expression to apply to the constraint. Does not need to be specified for the `distinctInstance` type. For more information, see [Cluster Query Language in the Amazon EC2 Container Service Developer Guide](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
 * @property type Type of constraint. The only valid values at this time are `memberOf` and `distinctInstance`.
 */
public data class EventTargetEcsTargetPlacementConstraint(
    public val expression: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetEcsTargetPlacementConstraint): EventTargetEcsTargetPlacementConstraint = EventTargetEcsTargetPlacementConstraint(
            expression = javaType.expression().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
