@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property database The name of the database.
 * @property dbUser The database user name.
 * @property secretsManagerArn The name or ARN of the secret that enables access to the database.
 * @property sql The SQL statement text to run.
 * @property statementName The name of the SQL statement.
 * @property withEvent Indicates whether to send an event back to EventBridge after the SQL statement runs.
 */
public data class EventTargetRedshiftTarget(
    public val database: String,
    public val dbUser: String? = null,
    public val secretsManagerArn: String? = null,
    public val sql: String? = null,
    public val statementName: String? = null,
    public val withEvent: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetRedshiftTarget): EventTargetRedshiftTarget = EventTargetRedshiftTarget(
            database = javaType.database(),
            dbUser = javaType.dbUser().map({ args0 -> args0 }).orElse(null),
            secretsManagerArn = javaType.secretsManagerArn().map({ args0 -> args0 }).orElse(null),
            sql = javaType.sql().map({ args0 -> args0 }).orElse(null),
            statementName = javaType.statementName().map({ args0 -> args0 }).orElse(null),
            withEvent = javaType.withEvent().map({ args0 -> args0 }).orElse(null),
        )
    }
}
