@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property maximumEventAgeInSeconds The age in seconds to continue to make retry attempts.
 * @property maximumRetryAttempts maximum number of retry attempts to make before the request fails
 */
public data class EventTargetRetryPolicy(
    public val maximumEventAgeInSeconds: Int? = null,
    public val maximumRetryAttempts: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.EventTargetRetryPolicy): EventTargetRetryPolicy = EventTargetRetryPolicy(
            maximumEventAgeInSeconds = javaType.maximumEventAgeInSeconds().map({ args0 -> args0 }).orElse(null),
            maximumRetryAttempts = javaType.maximumRetryAttempts().map({ args0 -> args0 }).orElse(null),
        )
    }
}
