@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEventBus.
 * @property arn ARN.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyIdentifier The identifier of the AWS KMS customer managed key for EventBridge to use to encrypt events on this event bus, if one has been specified.
 * @property name
 */
public data class GetEventBusResult(
    public val arn: String,
    public val id: String,
    public val kmsKeyIdentifier: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.GetEventBusResult): GetEventBusResult = GetEventBusResult(
            arn = javaType.arn(),
            id = javaType.id(),
            kmsKeyIdentifier = javaType.kmsKeyIdentifier(),
            name = javaType.name(),
        )
    }
}
