@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getEventConnection.
 * @property arn ARN (Amazon Resource Name) for the connection.
 * @property authorizationType Type of authorization to use to connect. One of `API_KEY`,`BASIC`,`OAUTH_CLIENT_CREDENTIALS`.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name Name of the connection.
 * @property secretArn ARN (Amazon Resource Name) for the secret created from the authorization parameters specified for the connection.
 */
public data class GetEventConnectionResult(
    public val arn: String,
    public val authorizationType: String,
    public val id: String,
    public val name: String,
    public val secretArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.GetEventConnectionResult): GetEventConnectionResult = GetEventConnectionResult(
            arn = javaType.arn(),
            authorizationType = javaType.authorizationType(),
            id = javaType.id(),
            name = javaType.name(),
            secretArn = javaType.secretArn(),
        )
    }
}
