@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getLogDataProtectionPolicyDocument.
 * @property description
 * @property id The provider-assigned unique ID for this managed resource.
 * @property json Standard JSON policy document rendered based on the arguments above.
 * @property name
 * @property statements
 * @property version
 */
public data class GetLogDataProtectionPolicyDocumentResult(
    public val description: String? = null,
    public val id: String,
    public val json: String,
    public val name: String,
    public val statements: List<GetLogDataProtectionPolicyDocumentStatement>,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.GetLogDataProtectionPolicyDocumentResult): GetLogDataProtectionPolicyDocumentResult = GetLogDataProtectionPolicyDocumentResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            json = javaType.json(),
            name = javaType.name(),
            statements = javaType.statements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.GetLogDataProtectionPolicyDocumentStatement.Companion.toKotlin(args0)
                })
            }),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
