@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dataIdentifiers Set of at least 1 sensitive data identifiers that you want to mask. Read more in [Types of data that you can protect](https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/protect-sensitive-log-data-types.html).
 * @property operation Configures the data protection operation applied by this statement.
 * @property sid Name of this statement.
 */
public data class GetLogDataProtectionPolicyDocumentStatement(
    public val dataIdentifiers: List<String>,
    public val operation: GetLogDataProtectionPolicyDocumentStatementOperation,
    public val sid: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.GetLogDataProtectionPolicyDocumentStatement): GetLogDataProtectionPolicyDocumentStatement = GetLogDataProtectionPolicyDocumentStatement(
            dataIdentifiers = javaType.dataIdentifiers().map({ args0 -> args0 }),
            operation = javaType.operation().let({ args0 ->
                com.pulumi.aws.cloudwatch.kotlin.outputs.GetLogDataProtectionPolicyDocumentStatementOperation.Companion.toKotlin(args0)
            }),
            sid = javaType.sid().map({ args0 -> args0 }).orElse(null),
        )
    }
}
