@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Double
import kotlin.Suppress

/**
 *
 * @property availabilityScoreThreshold The health event threshold percentage set for availability scores.
 * @property performanceScoreThreshold The health event threshold percentage set for performance scores.
 */
public data class InternetMonitorHealthEventsConfig(
    public val availabilityScoreThreshold: Double? = null,
    public val performanceScoreThreshold: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.InternetMonitorHealthEventsConfig): InternetMonitorHealthEventsConfig = InternetMonitorHealthEventsConfig(
            availabilityScoreThreshold = javaType.availabilityScoreThreshold().map({ args0 ->
                args0
            }).orElse(null),
            performanceScoreThreshold = javaType.performanceScoreThreshold().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
