@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property dimensions The dimensions for this metric.  For the list of available dimensions see the AWS documentation [here](http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
 * @property metricName The name for this metric.
 * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
 * @property namespace The namespace for this metric. See docs for the [list of namespaces](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/aws-namespaces.html).
 * See docs for [supported metrics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/CW_Support_For_AWS.html).
 * @property period Granularity in seconds of returned data points.
 * For metrics with regular resolution, valid values are any multiple of `60`.
 * For high-resolution metrics, valid values are `1`, `5`, `10`, `30`, or any multiple of `60`.
 * @property stat The statistic to apply to this metric.
 * See docs for [supported statistics](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Statistics-definitions.html).
 * @property unit The unit for this metric.
 */
public data class MetricAlarmMetricQueryMetric(
    public val dimensions: Map<String, String>? = null,
    public val metricName: String,
    public val namespace: String? = null,
    public val period: Int,
    public val stat: String,
    public val unit: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.MetricAlarmMetricQueryMetric): MetricAlarmMetricQueryMetric = MetricAlarmMetricQueryMetric(
            dimensions = javaType.dimensions().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            metricName = javaType.metricName(),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            period = javaType.period(),
            stat = javaType.stat(),
            unit = javaType.unit().map({ args0 -> args0 }).orElse(null),
        )
    }
}
