@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property metricNames An array that defines the metrics you want to include for this metric namespace
 * @property namespace Name of the metric namespace in the filter.
 */
public data class MetricStreamIncludeFilter(
    public val metricNames: List<String>? = null,
    public val namespace: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.MetricStreamIncludeFilter): MetricStreamIncludeFilter = MetricStreamIncludeFilter(
            metricNames = javaType.metricNames().map({ args0 -> args0 }),
            namespace = javaType.namespace(),
        )
    }
}
