@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.cloudwatch.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property additionalStatistics The additional statistics to stream for the metrics listed in `include_metrics`.
 * @property includeMetrics An array that defines the metrics that are to have additional statistics streamed. See details below.
 */
public data class MetricStreamStatisticsConfiguration(
    public val additionalStatistics: List<String>,
    public val includeMetrics: List<MetricStreamStatisticsConfigurationIncludeMetric>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.cloudwatch.outputs.MetricStreamStatisticsConfiguration): MetricStreamStatisticsConfiguration = MetricStreamStatisticsConfiguration(
            additionalStatistics = javaType.additionalStatistics().map({ args0 -> args0 }),
            includeMetrics = javaType.includeMetrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.cloudwatch.kotlin.outputs.MetricStreamStatisticsConfigurationIncludeMetric.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
