@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DomainPermissions].
 */
@PulumiTagMarker
public class DomainPermissionsResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainPermissionsArgs = DomainPermissionsArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainPermissionsArgsBuilder.() -> Unit) {
        val builder = DomainPermissionsArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DomainPermissions {
        val builtJavaResource = com.pulumi.aws.codeartifact.DomainPermissions(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DomainPermissions(builtJavaResource)
    }
}

/**
 * Provides a CodeArtifact Domains Permissions Policy Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {description: "domain key"});
 * const exampleDomain = new aws.codeartifact.Domain("example", {
 *     domain: "example",
 *     encryptionKey: example.arn,
 * });
 * const test = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "*",
 *             identifiers: ["*"],
 *         }],
 *         actions: ["codeartifact:CreateRepository"],
 *         resources: [exampleDomain&#46;arn],
 *     }],
 * });
 * const testDomainPermissions = new aws.codeartifact.DomainPermissions("test", {
 *     domain: exampleDomain.domain,
 *     policyDocument: test.apply(test => test.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example", description="domain key")
 * example_domain = aws.codeartifact.Domain("example",
 *     domain="example",
 *     encryption_key=example.arn)
 * test = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "*",
 *         "identifiers": ["*"],
 *     }],
 *     "actions": ["codeartifact:CreateRepository"],
 *     "resources": [example_domain&#46;arn],
 * }])
 * test_domain_permissions = aws.codeartifact.DomainPermissions("test",
 *     domain=example_domain.domain,
 *     policy_document=test.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "domain key",
 *     });
 *     var exampleDomain = new Aws.CodeArtifact.Domain("example", new()
 *     {
 *         DomainName = "example",
 *         EncryptionKey = example.Arn,
 *     });
 *     var test = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "*",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "codeartifact:CreateRepository",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleDomain.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var testDomainPermissions = new Aws.CodeArtifact.DomainPermissions("test", new()
 *     {
 *         Domain = exampleDomain.DomainName,
 *         PolicyDocument = test.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codeartifact"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description: pulumi.String("domain key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleDomain, err := codeartifact.NewDomain(ctx, "example", &codeartifact.DomainArgs{
 * 			Domain:        pulumi.String("example"),
 * 			EncryptionKey: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		test := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Principals: iam.GetPolicyDocumentStatementPrincipalArray{
 * 						&iam.GetPolicyDocumentStatementPrincipalArgs{
 * 							Type: pulumi.String("*"),
 * 							Identifiers: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 						},
 * 					},
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("codeartifact:CreateRepository"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						exampleDomain.Arn,
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = codeartifact.NewDomainPermissions(ctx, "test", &codeartifact.DomainPermissionsArgs{
 * 			Domain: exampleDomain.Domain,
 * 			PolicyDocument: pulumi.String(test.ApplyT(func(test iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &test.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.codeartifact.DomainPermissions;
 * import com.pulumi.aws.codeartifact.DomainPermissionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("domain key")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domain("example")
 *             .encryptionKey(example.arn())
 *             .build());
 *         final var test = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("codeartifact:CreateRepository")
 *                 .resources(exampleDomain.arn())
 *                 .build())
 *             .build());
 *         var testDomainPermissions = new DomainPermissions("testDomainPermissions", DomainPermissionsArgs.builder()
 *             .domain(exampleDomain.domain())
 *             .policyDocument(test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(test -> test.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: domain key
 *   exampleDomain:
 *     type: aws:codeartifact:Domain
 *     name: example
 *     properties:
 *       domain: example
 *       encryptionKey: ${example.arn}
 *   testDomainPermissions:
 *     type: aws:codeartifact:DomainPermissions
 *     name: test
 *     properties:
 *       domain: ${exampleDomain.domain}
 *       policyDocument: ${test.json}
 * variables:
 *   test:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: '*'
 *                 identifiers:
 *                   - '*'
 *             actions:
 *               - codeartifact:CreateRepository
 *             resources:
 *               - ${exampleDomain.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeArtifact Domain Permissions Policies using the CodeArtifact Domain ARN. For example:
 * ```sh
 * $ pulumi import aws:codeartifact/domainPermissions:DomainPermissions example arn:aws:codeartifact:us-west-2:012345678912:domain/tf-acc-test-1928056699409417367
 * ```
 */
public class DomainPermissions internal constructor(
    override val javaResource: com.pulumi.aws.codeartifact.DomainPermissions,
) : KotlinCustomResource(javaResource, DomainPermissionsMapper) {
    /**
     * The name of the domain on which to set the resource policy.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The account number of the AWS account that owns the domain.
     */
    public val domainOwner: Output<String>
        get() = javaResource.domainOwner().applyValue({ args0 -> args0 })

    /**
     * A JSON policy string to be set as the access control resource policy on the provided domain.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })

    /**
     * The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy.
     */
    public val policyRevision: Output<String>
        get() = javaResource.policyRevision().applyValue({ args0 -> args0 })

    /**
     * The ARN of the resource associated with the resource policy.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object DomainPermissionsMapper : ResourceMapper<DomainPermissions> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codeartifact.DomainPermissions::class == javaResource::class

    override fun map(javaResource: Resource): DomainPermissions = DomainPermissions(
        javaResource as
            com.pulumi.aws.codeartifact.DomainPermissions,
    )
}

/**
 * @see [DomainPermissions].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DomainPermissions].
 */
public suspend fun domainPermissions(
    name: String,
    block: suspend DomainPermissionsResourceBuilder.() -> Unit,
): DomainPermissions {
    val builder = DomainPermissionsResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DomainPermissions].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domainPermissions(name: String): DomainPermissions {
    val builder = DomainPermissionsResourceBuilder()
    builder.name(name)
    return builder.build()
}
