@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.aws.codeartifact.RepositoryArgs.builder
import com.pulumi.aws.codeartifact.kotlin.inputs.RepositoryExternalConnectionsArgs
import com.pulumi.aws.codeartifact.kotlin.inputs.RepositoryExternalConnectionsArgsBuilder
import com.pulumi.aws.codeartifact.kotlin.inputs.RepositoryUpstreamArgs
import com.pulumi.aws.codeartifact.kotlin.inputs.RepositoryUpstreamArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeArtifact Repository Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {description: "domain key"});
 * const exampleDomain = new aws.codeartifact.Domain("example", {
 *     domain: "example",
 *     encryptionKey: example.arn,
 * });
 * const test = new aws.codeartifact.Repository("test", {
 *     repository: "example",
 *     domain: exampleDomain.domain,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example", description="domain key")
 * example_domain = aws.codeartifact.Domain("example",
 *     domain="example",
 *     encryption_key=example.arn)
 * test = aws.codeartifact.Repository("test",
 *     repository="example",
 *     domain=example_domain.domain)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "domain key",
 *     });
 *     var exampleDomain = new Aws.CodeArtifact.Domain("example", new()
 *     {
 *         DomainName = "example",
 *         EncryptionKey = example.Arn,
 *     });
 *     var test = new Aws.CodeArtifact.Repository("test", new()
 *     {
 *         RepositoryName = "example",
 *         Domain = exampleDomain.DomainName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codeartifact"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description: pulumi.String("domain key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleDomain, err := codeartifact.NewDomain(ctx, "example", &codeartifact.DomainArgs{
 * 			Domain:        pulumi.String("example"),
 * 			EncryptionKey: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codeartifact.NewRepository(ctx, "test", &codeartifact.RepositoryArgs{
 * 			Repository: pulumi.String("example"),
 * 			Domain:     exampleDomain.Domain,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example", KeyArgs.builder()
 *             .description("domain key")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domain("example")
 *             .encryptionKey(example.arn())
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(exampleDomain.domain())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *     properties:
 *       description: domain key
 *   exampleDomain:
 *     type: aws:codeartifact:Domain
 *     name: example
 *     properties:
 *       domain: example
 *       encryptionKey: ${example.arn}
 *   test:
 *     type: aws:codeartifact:Repository
 *     properties:
 *       repository: example
 *       domain: ${exampleDomain.domain}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Upstream Repository
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const upstream = new aws.codeartifact.Repository("upstream", {
 *     repository: "upstream",
 *     domain: testAwsCodeartifactDomain.domain,
 * });
 * const test = new aws.codeartifact.Repository("test", {
 *     repository: "example",
 *     domain: example.domain,
 *     upstreams: [{
 *         repositoryName: upstream.repository,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * upstream = aws.codeartifact.Repository("upstream",
 *     repository="upstream",
 *     domain=test_aws_codeartifact_domain["domain"])
 * test = aws.codeartifact.Repository("test",
 *     repository="example",
 *     domain=example["domain"],
 *     upstreams=[{
 *         "repository_name": upstream.repository,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var upstream = new Aws.CodeArtifact.Repository("upstream", new()
 *     {
 *         RepositoryName = "upstream",
 *         Domain = testAwsCodeartifactDomain.Domain,
 *     });
 *     var test = new Aws.CodeArtifact.Repository("test", new()
 *     {
 *         RepositoryName = "example",
 *         Domain = example.Domain,
 *         Upstreams = new[]
 *         {
 *             new Aws.CodeArtifact.Inputs.RepositoryUpstreamArgs
 *             {
 *                 RepositoryName = upstream.RepositoryName,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codeartifact"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		upstream, err := codeartifact.NewRepository(ctx, "upstream", &codeartifact.RepositoryArgs{
 * 			Repository: pulumi.String("upstream"),
 * 			Domain:     pulumi.Any(testAwsCodeartifactDomain.Domain),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codeartifact.NewRepository(ctx, "test", &codeartifact.RepositoryArgs{
 * 			Repository: pulumi.String("example"),
 * 			Domain:     pulumi.Any(example.Domain),
 * 			Upstreams: codeartifact.RepositoryUpstreamArray{
 * 				&codeartifact.RepositoryUpstreamArgs{
 * 					RepositoryName: upstream.Repository,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import com.pulumi.aws.codeartifact.inputs.RepositoryUpstreamArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var upstream = new Repository("upstream", RepositoryArgs.builder()
 *             .repository("upstream")
 *             .domain(testAwsCodeartifactDomain.domain())
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(example.domain())
 *             .upstreams(RepositoryUpstreamArgs.builder()
 *                 .repositoryName(upstream.repository())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   upstream:
 *     type: aws:codeartifact:Repository
 *     properties:
 *       repository: upstream
 *       domain: ${testAwsCodeartifactDomain.domain}
 *   test:
 *     type: aws:codeartifact:Repository
 *     properties:
 *       repository: example
 *       domain: ${example.domain}
 *       upstreams:
 *         - repositoryName: ${upstream.repository}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With External Connection
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const upstream = new aws.codeartifact.Repository("upstream", {
 *     repository: "upstream",
 *     domain: testAwsCodeartifactDomain.domain,
 * });
 * const test = new aws.codeartifact.Repository("test", {
 *     repository: "example",
 *     domain: example.domain,
 *     externalConnections: {
 *         externalConnectionName: "public:npmjs",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * upstream = aws.codeartifact.Repository("upstream",
 *     repository="upstream",
 *     domain=test_aws_codeartifact_domain["domain"])
 * test = aws.codeartifact.Repository("test",
 *     repository="example",
 *     domain=example["domain"],
 *     external_connections={
 *         "external_connection_name": "public:npmjs",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var upstream = new Aws.CodeArtifact.Repository("upstream", new()
 *     {
 *         RepositoryName = "upstream",
 *         Domain = testAwsCodeartifactDomain.Domain,
 *     });
 *     var test = new Aws.CodeArtifact.Repository("test", new()
 *     {
 *         RepositoryName = "example",
 *         Domain = example.Domain,
 *         ExternalConnections = new Aws.CodeArtifact.Inputs.RepositoryExternalConnectionsArgs
 *         {
 *             ExternalConnectionName = "public:npmjs",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codeartifact"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codeartifact.NewRepository(ctx, "upstream", &codeartifact.RepositoryArgs{
 * 			Repository: pulumi.String("upstream"),
 * 			Domain:     pulumi.Any(testAwsCodeartifactDomain.Domain),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codeartifact.NewRepository(ctx, "test", &codeartifact.RepositoryArgs{
 * 			Repository: pulumi.String("example"),
 * 			Domain:     pulumi.Any(example.Domain),
 * 			ExternalConnections: &codeartifact.RepositoryExternalConnectionsArgs{
 * 				ExternalConnectionName: pulumi.String("public:npmjs"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import com.pulumi.aws.codeartifact.inputs.RepositoryExternalConnectionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var upstream = new Repository("upstream", RepositoryArgs.builder()
 *             .repository("upstream")
 *             .domain(testAwsCodeartifactDomain.domain())
 *             .build());
 *         var test = new Repository("test", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(example.domain())
 *             .externalConnections(RepositoryExternalConnectionsArgs.builder()
 *                 .externalConnectionName("public:npmjs")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   upstream:
 *     type: aws:codeartifact:Repository
 *     properties:
 *       repository: upstream
 *       domain: ${testAwsCodeartifactDomain.domain}
 *   test:
 *     type: aws:codeartifact:Repository
 *     properties:
 *       repository: example
 *       domain: ${example.domain}
 *       externalConnections:
 *         externalConnectionName: public:npmjs
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeArtifact Repository using the CodeArtifact Repository ARN. For example:
 * ```sh
 * $ pulumi import aws:codeartifact/repository:Repository example arn:aws:codeartifact:us-west-2:012345678912:repository/tf-acc-test-6968272603913957763/tf-acc-test-6968272603913957763
 * ```
 * @property description The description of the repository.
 * @property domain The domain that contains the created repository.
 * @property domainOwner The account number of the AWS account that owns the domain.
 * @property externalConnections An array of external connections associated with the repository. Only one external connection can be set per repository. see External Connections.
 * @property repository The name of the repository to create.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property upstreams A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
 */
public data class RepositoryArgs(
    public val description: Output<String>? = null,
    public val domain: Output<String>? = null,
    public val domainOwner: Output<String>? = null,
    public val externalConnections: Output<RepositoryExternalConnectionsArgs>? = null,
    public val repository: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val upstreams: Output<List<RepositoryUpstreamArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.codeartifact.RepositoryArgs> {
    override fun toJava(): com.pulumi.aws.codeartifact.RepositoryArgs =
        com.pulumi.aws.codeartifact.RepositoryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .domain(domain?.applyValue({ args0 -> args0 }))
            .domainOwner(domainOwner?.applyValue({ args0 -> args0 }))
            .externalConnections(
                externalConnections?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .repository(repository?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .upstreams(
                upstreams?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [RepositoryArgs].
 */
@PulumiTagMarker
public class RepositoryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var domain: Output<String>? = null

    private var domainOwner: Output<String>? = null

    private var externalConnections: Output<RepositoryExternalConnectionsArgs>? = null

    private var repository: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var upstreams: Output<List<RepositoryUpstreamArgs>>? = null

    /**
     * @param value The description of the repository.
     */
    @JvmName("ufofkssawlgxvyuv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The domain that contains the created repository.
     */
    @JvmName("lqjghulvckjndopi")
    public suspend fun domain(`value`: Output<String>) {
        this.domain = value
    }

    /**
     * @param value The account number of the AWS account that owns the domain.
     */
    @JvmName("ldvxuvbvwbppiwac")
    public suspend fun domainOwner(`value`: Output<String>) {
        this.domainOwner = value
    }

    /**
     * @param value An array of external connections associated with the repository. Only one external connection can be set per repository. see External Connections.
     */
    @JvmName("rtpjoexbantmfmln")
    public suspend fun externalConnections(`value`: Output<RepositoryExternalConnectionsArgs>) {
        this.externalConnections = value
    }

    /**
     * @param value The name of the repository to create.
     */
    @JvmName("aowmirivvthxkyid")
    public suspend fun repository(`value`: Output<String>) {
        this.repository = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("gcfisnkameqklexa")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("avmcbggtqaqoupat")
    public suspend fun upstreams(`value`: Output<List<RepositoryUpstreamArgs>>) {
        this.upstreams = value
    }

    @JvmName("riretrnhyqihkndu")
    public suspend fun upstreams(vararg values: Output<RepositoryUpstreamArgs>) {
        this.upstreams = Output.all(values.asList())
    }

    /**
     * @param values A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("iviaxhlskueqhude")
    public suspend fun upstreams(values: List<Output<RepositoryUpstreamArgs>>) {
        this.upstreams = Output.all(values)
    }

    /**
     * @param value The description of the repository.
     */
    @JvmName("opnoqixwmklanqwk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The domain that contains the created repository.
     */
    @JvmName("iplufqtebifylhsn")
    public suspend fun domain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The account number of the AWS account that owns the domain.
     */
    @JvmName("idjtqjwqxocbngsd")
    public suspend fun domainOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainOwner = mapped
    }

    /**
     * @param value An array of external connections associated with the repository. Only one external connection can be set per repository. see External Connections.
     */
    @JvmName("alkqwduisufaelsj")
    public suspend fun externalConnections(`value`: RepositoryExternalConnectionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.externalConnections = mapped
    }

    /**
     * @param argument An array of external connections associated with the repository. Only one external connection can be set per repository. see External Connections.
     */
    @JvmName("mhklebhxekpbchtm")
    public suspend fun externalConnections(argument: suspend RepositoryExternalConnectionsArgsBuilder.() -> Unit) {
        val toBeMapped = RepositoryExternalConnectionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.externalConnections = mapped
    }

    /**
     * @param value The name of the repository to create.
     */
    @JvmName("tjifhnrpbfoopfts")
    public suspend fun repository(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.repository = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("rmveiowggskxooll")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kvhamulauvracchh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("xgjflvgiklxufwif")
    public suspend fun upstreams(`value`: List<RepositoryUpstreamArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upstreams = mapped
    }

    /**
     * @param argument A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("wxvwpqjniavcbnrt")
    public suspend fun upstreams(argument: List<suspend RepositoryUpstreamArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RepositoryUpstreamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.upstreams = mapped
    }

    /**
     * @param argument A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("biwgmthiovdfyird")
    public suspend fun upstreams(vararg argument: suspend RepositoryUpstreamArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RepositoryUpstreamArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.upstreams = mapped
    }

    /**
     * @param argument A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("svmfaibsbcwjdukh")
    public suspend fun upstreams(argument: suspend RepositoryUpstreamArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RepositoryUpstreamArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.upstreams = mapped
    }

    /**
     * @param values A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. see Upstream
     */
    @JvmName("txtroekhqgqhmigd")
    public suspend fun upstreams(vararg values: RepositoryUpstreamArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.upstreams = mapped
    }

    internal fun build(): RepositoryArgs = RepositoryArgs(
        description = description,
        domain = domain,
        domainOwner = domainOwner,
        externalConnections = externalConnections,
        repository = repository,
        tags = tags,
        upstreams = upstreams,
    )
}
