@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RepositoryPermissionsPolicy].
 */
@PulumiTagMarker
public class RepositoryPermissionsPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RepositoryPermissionsPolicyArgs = RepositoryPermissionsPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RepositoryPermissionsPolicyArgsBuilder.() -> Unit) {
        val builder = RepositoryPermissionsPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RepositoryPermissionsPolicy {
        val builtJavaResource =
            com.pulumi.aws.codeartifact.RepositoryPermissionsPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return RepositoryPermissionsPolicy(builtJavaResource)
    }
}

/**
 * Provides a CodeArtifact Repostory Permissions Policy Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleKey = new aws.kms.Key("example", {description: "domain key"});
 * const exampleDomain = new aws.codeartifact.Domain("example", {
 *     domain: "example",
 *     encryptionKey: exampleKey.arn,
 * });
 * const exampleRepository = new aws.codeartifact.Repository("example", {
 *     repository: "example",
 *     domain: exampleDomain.domain,
 * });
 * const example = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "*",
 *             identifiers: ["*"],
 *         }],
 *         actions: ["codeartifact:ReadFromRepository"],
 *         resources: [exampleRepository&#46;arn],
 *     }],
 * });
 * const exampleRepositoryPermissionsPolicy = new aws.codeartifact.RepositoryPermissionsPolicy("example", {
 *     repository: exampleRepository.repository,
 *     domain: exampleDomain.domain,
 *     policyDocument: example.apply(example => example.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_key = aws.kms.Key("example", description="domain key")
 * example_domain = aws.codeartifact.Domain("example",
 *     domain="example",
 *     encryption_key=example_key.arn)
 * example_repository = aws.codeartifact.Repository("example",
 *     repository="example",
 *     domain=example_domain.domain)
 * example = aws.iam.get_policy_document_output(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "*",
 *         "identifiers": ["*"],
 *     }],
 *     "actions": ["codeartifact:ReadFromRepository"],
 *     "resources": [example_repository&#46;arn],
 * }])
 * example_repository_permissions_policy = aws.codeartifact.RepositoryPermissionsPolicy("example",
 *     repository=example_repository.repository,
 *     domain=example_domain.domain,
 *     policy_document=example.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleKey = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "domain key",
 *     });
 *     var exampleDomain = new Aws.CodeArtifact.Domain("example", new()
 *     {
 *         DomainName = "example",
 *         EncryptionKey = exampleKey.Arn,
 *     });
 *     var exampleRepository = new Aws.CodeArtifact.Repository("example", new()
 *     {
 *         RepositoryName = "example",
 *         Domain = exampleDomain.DomainName,
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "*",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "codeartifact:ReadFromRepository",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleRepository.Arn,
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRepositoryPermissionsPolicy = new Aws.CodeArtifact.RepositoryPermissionsPolicy("example", new()
 *     {
 *         Repository = exampleRepository.RepositoryName,
 *         Domain = exampleDomain.DomainName,
 *         PolicyDocument = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codeartifact"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description: pulumi.String("domain key"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleDomain, err := codeartifact.NewDomain(ctx, "example", &codeartifact.DomainArgs{
 * 			Domain:        pulumi.String("example"),
 * 			EncryptionKey: exampleKey.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleRepository, err := codeartifact.NewRepository(ctx, "example", &codeartifact.RepositoryArgs{
 * 			Repository: pulumi.String("example"),
 * 			Domain:     exampleDomain.Domain,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Effect: pulumi.String("Allow"),
 * 					Principals: iam.GetPolicyDocumentStatementPrincipalArray{
 * 						&iam.GetPolicyDocumentStatementPrincipalArgs{
 * 							Type: pulumi.String("*"),
 * 							Identifiers: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 						},
 * 					},
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("codeartifact:ReadFromRepository"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						exampleRepository.Arn,
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = codeartifact.NewRepositoryPermissionsPolicy(ctx, "example", &codeartifact.RepositoryPermissionsPolicyArgs{
 * 			Repository: exampleRepository.Repository,
 * 			Domain:     exampleDomain.Domain,
 * 			PolicyDocument: pulumi.String(example.ApplyT(func(example iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &example.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.codeartifact.Domain;
 * import com.pulumi.aws.codeartifact.DomainArgs;
 * import com.pulumi.aws.codeartifact.Repository;
 * import com.pulumi.aws.codeartifact.RepositoryArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.codeartifact.RepositoryPermissionsPolicy;
 * import com.pulumi.aws.codeartifact.RepositoryPermissionsPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("domain key")
 *             .build());
 *         var exampleDomain = new Domain("exampleDomain", DomainArgs.builder()
 *             .domain("example")
 *             .encryptionKey(exampleKey.arn())
 *             .build());
 *         var exampleRepository = new Repository("exampleRepository", RepositoryArgs.builder()
 *             .repository("example")
 *             .domain(exampleDomain.domain())
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("*")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions("codeartifact:ReadFromRepository")
 *                 .resources(exampleRepository.arn())
 *                 .build())
 *             .build());
 *         var exampleRepositoryPermissionsPolicy = new RepositoryPermissionsPolicy("exampleRepositoryPermissionsPolicy", RepositoryPermissionsPolicyArgs.builder()
 *             .repository(exampleRepository.repository())
 *             .domain(exampleDomain.domain())
 *             .policyDocument(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(example -> example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleKey:
 *     type: aws:kms:Key
 *     name: example
 *     properties:
 *       description: domain key
 *   exampleDomain:
 *     type: aws:codeartifact:Domain
 *     name: example
 *     properties:
 *       domain: example
 *       encryptionKey: ${exampleKey.arn}
 *   exampleRepository:
 *     type: aws:codeartifact:Repository
 *     name: example
 *     properties:
 *       repository: example
 *       domain: ${exampleDomain.domain}
 *   exampleRepositoryPermissionsPolicy:
 *     type: aws:codeartifact:RepositoryPermissionsPolicy
 *     name: example
 *     properties:
 *       repository: ${exampleRepository.repository}
 *       domain: ${exampleDomain.domain}
 *       policyDocument: ${example.json}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: '*'
 *                 identifiers:
 *                   - '*'
 *             actions:
 *               - codeartifact:ReadFromRepository
 *             resources:
 *               - ${exampleRepository.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeArtifact Repository Permissions Policies using the CodeArtifact Repository ARN. For example:
 * ```sh
 * $ pulumi import aws:codeartifact/repositoryPermissionsPolicy:RepositoryPermissionsPolicy example arn:aws:codeartifact:us-west-2:012345678912:repository/tf-acc-test-6968272603913957763/tf-acc-test-6968272603913957763
 * ```
 */
public class RepositoryPermissionsPolicy internal constructor(
    override val javaResource: com.pulumi.aws.codeartifact.RepositoryPermissionsPolicy,
) : KotlinCustomResource(javaResource, RepositoryPermissionsPolicyMapper) {
    /**
     * The name of the domain on which to set the resource policy.
     */
    public val domain: Output<String>
        get() = javaResource.domain().applyValue({ args0 -> args0 })

    /**
     * The account number of the AWS account that owns the domain.
     */
    public val domainOwner: Output<String>
        get() = javaResource.domainOwner().applyValue({ args0 -> args0 })

    /**
     * A JSON policy string to be set as the access control resource policy on the provided domain.
     */
    public val policyDocument: Output<String>
        get() = javaResource.policyDocument().applyValue({ args0 -> args0 })

    /**
     * The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy.
     */
    public val policyRevision: Output<String>
        get() = javaResource.policyRevision().applyValue({ args0 -> args0 })

    /**
     * The name of the repository to set the resource policy on.
     */
    public val repository: Output<String>
        get() = javaResource.repository().applyValue({ args0 -> args0 })

    /**
     * The ARN of the resource associated with the resource policy.
     */
    public val resourceArn: Output<String>
        get() = javaResource.resourceArn().applyValue({ args0 -> args0 })
}

public object RepositoryPermissionsPolicyMapper : ResourceMapper<RepositoryPermissionsPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codeartifact.RepositoryPermissionsPolicy::class == javaResource::class

    override fun map(javaResource: Resource): RepositoryPermissionsPolicy =
        RepositoryPermissionsPolicy(
            javaResource as
                com.pulumi.aws.codeartifact.RepositoryPermissionsPolicy,
        )
}

/**
 * @see [RepositoryPermissionsPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RepositoryPermissionsPolicy].
 */
public suspend fun repositoryPermissionsPolicy(
    name: String,
    block: suspend RepositoryPermissionsPolicyResourceBuilder.() -> Unit,
): RepositoryPermissionsPolicy {
    val builder = RepositoryPermissionsPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RepositoryPermissionsPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun repositoryPermissionsPolicy(name: String): RepositoryPermissionsPolicy {
    val builder = RepositoryPermissionsPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
