@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin.inputs

import com.pulumi.aws.codeartifact.inputs.GetAuthorizationTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAuthorizationToken.
 * @property domain Name of the domain that is in scope for the generated authorization token.
 * @property domainOwner Account number of the AWS account that owns the domain.
 * @property durationSeconds Time, in seconds, that the generated authorization token is valid. Valid values are `0` and between `900` and `43200`.
 */
public data class GetAuthorizationTokenPlainArgs(
    public val domain: String,
    public val domainOwner: String? = null,
    public val durationSeconds: Int? = null,
) : ConvertibleToJava<com.pulumi.aws.codeartifact.inputs.GetAuthorizationTokenPlainArgs> {
    override fun toJava(): com.pulumi.aws.codeartifact.inputs.GetAuthorizationTokenPlainArgs =
        com.pulumi.aws.codeartifact.inputs.GetAuthorizationTokenPlainArgs.builder()
            .domain(domain.let({ args0 -> args0 }))
            .domainOwner(domainOwner?.let({ args0 -> args0 }))
            .durationSeconds(durationSeconds?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAuthorizationTokenPlainArgs].
 */
@PulumiTagMarker
public class GetAuthorizationTokenPlainArgsBuilder internal constructor() {
    private var domain: String? = null

    private var domainOwner: String? = null

    private var durationSeconds: Int? = null

    /**
     * @param value Name of the domain that is in scope for the generated authorization token.
     */
    @JvmName("fsgofpuqasuvyjtk")
    public suspend fun domain(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domain = mapped
    }

    /**
     * @param value Account number of the AWS account that owns the domain.
     */
    @JvmName("ftpqrlnwjujopipw")
    public suspend fun domainOwner(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainOwner = mapped
    }

    /**
     * @param value Time, in seconds, that the generated authorization token is valid. Valid values are `0` and between `900` and `43200`.
     */
    @JvmName("jxtwrhmxxbskfdwo")
    public suspend fun durationSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.durationSeconds = mapped
    }

    internal fun build(): GetAuthorizationTokenPlainArgs = GetAuthorizationTokenPlainArgs(
        domain = domain ?: throw PulumiNullFieldException("domain"),
        domainOwner = domainOwner,
        durationSeconds = durationSeconds,
    )
}
