@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin.inputs

import com.pulumi.aws.codeartifact.inputs.RepositoryExternalConnectionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property externalConnectionName The name of the external connection associated with a repository.
 * @property packageFormat
 * @property status
 */
public data class RepositoryExternalConnectionsArgs(
    public val externalConnectionName: Output<String>,
    public val packageFormat: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codeartifact.inputs.RepositoryExternalConnectionsArgs> {
    override fun toJava(): com.pulumi.aws.codeartifact.inputs.RepositoryExternalConnectionsArgs =
        com.pulumi.aws.codeartifact.inputs.RepositoryExternalConnectionsArgs.builder()
            .externalConnectionName(externalConnectionName.applyValue({ args0 -> args0 }))
            .packageFormat(packageFormat?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RepositoryExternalConnectionsArgs].
 */
@PulumiTagMarker
public class RepositoryExternalConnectionsArgsBuilder internal constructor() {
    private var externalConnectionName: Output<String>? = null

    private var packageFormat: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value The name of the external connection associated with a repository.
     */
    @JvmName("dvfifkcihmnlqnun")
    public suspend fun externalConnectionName(`value`: Output<String>) {
        this.externalConnectionName = value
    }

    /**
     * @param value
     */
    @JvmName("dmyroipkriefnydh")
    public suspend fun packageFormat(`value`: Output<String>) {
        this.packageFormat = value
    }

    /**
     * @param value
     */
    @JvmName("litiwspvkbuirjls")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value The name of the external connection associated with a repository.
     */
    @JvmName("nkmwshbhlwpwgktf")
    public suspend fun externalConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.externalConnectionName = mapped
    }

    /**
     * @param value
     */
    @JvmName("vhxtlwamnpcxmbtb")
    public suspend fun packageFormat(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageFormat = mapped
    }

    /**
     * @param value
     */
    @JvmName("qlixbesrwxfxoosi")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): RepositoryExternalConnectionsArgs = RepositoryExternalConnectionsArgs(
        externalConnectionName = externalConnectionName ?: throw
            PulumiNullFieldException("externalConnectionName"),
        packageFormat = packageFormat,
        status = status,
    )
}
