@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getRepositoryEndpoint.
 * @property domain
 * @property domainOwner
 * @property format
 * @property id The provider-assigned unique ID for this managed resource.
 * @property repository
 * @property repositoryEndpoint URL of the returned endpoint.
 */
public data class GetRepositoryEndpointResult(
    public val domain: String,
    public val domainOwner: String,
    public val format: String,
    public val id: String,
    public val repository: String,
    public val repositoryEndpoint: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codeartifact.outputs.GetRepositoryEndpointResult): GetRepositoryEndpointResult = GetRepositoryEndpointResult(
            domain = javaType.domain(),
            domainOwner = javaType.domainOwner(),
            format = javaType.format(),
            id = javaType.id(),
            repository = javaType.repository(),
            repositoryEndpoint = javaType.repositoryEndpoint(),
        )
    }
}
