@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codeartifact.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property externalConnectionName The name of the external connection associated with a repository.
 * @property packageFormat
 * @property status
 */
public data class RepositoryExternalConnections(
    public val externalConnectionName: String,
    public val packageFormat: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.codeartifact.outputs.RepositoryExternalConnections): RepositoryExternalConnections = RepositoryExternalConnections(
            externalConnectionName = javaType.externalConnectionName(),
            packageFormat = javaType.packageFormat().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
