@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.kotlin.outputs.ProjectArtifacts
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectBuildBatchConfig
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectCache
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectEnvironment
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectFileSystemLocation
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectLogsConfig
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondaryArtifact
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySource
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySourceVersion
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSource
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectArtifacts.Companion.toKotlin as projectArtifactsToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectBuildBatchConfig.Companion.toKotlin as projectBuildBatchConfigToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectCache.Companion.toKotlin as projectCacheToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectEnvironment.Companion.toKotlin as projectEnvironmentToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectFileSystemLocation.Companion.toKotlin as projectFileSystemLocationToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectLogsConfig.Companion.toKotlin as projectLogsConfigToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondaryArtifact.Companion.toKotlin as projectSecondaryArtifactToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySource.Companion.toKotlin as projectSecondarySourceToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSecondarySourceVersion.Companion.toKotlin as projectSecondarySourceVersionToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectSource.Companion.toKotlin as projectSourceToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.ProjectVpcConfig.Companion.toKotlin as projectVpcConfigToKotlin

/**
 * Builder for [Project].
 */
@PulumiTagMarker
public class ProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProjectArgs = ProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProjectArgsBuilder.() -> Unit) {
        val builder = ProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Project {
        val builtJavaResource = com.pulumi.aws.codebuild.Project(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Project(builtJavaResource)
    }
}

/**
 * Provides a CodeBuild Project resource. See also the `aws.codebuild.Webhook` resource, which manages the webhook to the source (e.g., the "rebuild every time a code change is pushed" option in the CodeBuild web console).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleBucketAclV2 = new aws.s3.BucketAclV2("example", {
 *     bucket: exampleBucketV2.id,
 *     acl: "private",
 * });
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["codebuild&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const example = pulumi.all([exampleBucketV2&#46;arn, exampleBucketV2&#46;arn])&#46;apply(([exampleBucketV2Arn, exampleBucketV2Arn1]) => aws.iam.getPolicyDocumentOutput({
 *     statements: [
 *         {
 *             effect: "Allow",
 *             actions: [
 *                 "logs:CreateLogGroup",
 *                 "logs:CreateLogStream",
 *                 "logs:PutLogEvents",
 *             ],
 *             resources: ["*"],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: [
 *                 "ec2:CreateNetworkInterface",
 *                 "ec2:DescribeDhcpOptions",
 *                 "ec2:DescribeNetworkInterfaces",
 *                 "ec2:DeleteNetworkInterface",
 *                 "ec2:DescribeSubnets",
 *                 "ec2:DescribeSecurityGroups",
 *                 "ec2:DescribeVpcs",
 *             ],
 *             resources: ["*"],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: ["ec2:CreateNetworkInterfacePermission"],
 *             resources: ["arn:aws:ec2:us-east-1:123456789012:network-interface/*"],
 *             conditions: [
 *                 {
 *                     test: "StringEquals",
 *                     variable: "ec2:Subnet",
 *                     values: [
 *                         example1.arn,
 *                         example2.arn,
 *                     ],
 *                 },
 *                 {
 *                     test: "StringEquals",
 *                     variable: "ec2:AuthorizedService",
 *                     values: ["codebuild&#46;amazonaws&#46;com"],
 *                 },
 *             ],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: ["s3:*"],
 *             resources: [
 *                 exampleBucketV2Arn,
 *                 `${exampleBucketV2Arn1}/*`,
 *             ],
 *         },
 *     ],
 * }));
 * const exampleRolePolicy = new aws.iam.RolePolicy("example", {
 *     role: exampleRole.name,
 *     policy: example.apply(example => example.json),
 * });
 * const exampleProject = new aws.codebuild.Project("example", {
 *     name: "test-project",
 *     description: "test_codebuild_project",
 *     buildTimeout: 5,
 *     serviceRole: exampleRole.arn,
 *     artifacts: {
 *         type: "NO_ARTIFACTS",
 *     },
 *     cache: {
 *         type: "S3",
 *         location: exampleBucketV2.bucket,
 *     },
 *     environment: {
 *         computeType: "BUILD_GENERAL1_SMALL",
 *         image: "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *         type: "LINUX_CONTAINER",
 *         imagePullCredentialsType: "CODEBUILD",
 *         environmentVariables: [
 *             {
 *                 name: "SOME_KEY1",
 *                 value: "SOME_VALUE1",
 *             },
 *             {
 *                 name: "SOME_KEY2",
 *                 value: "SOME_VALUE2",
 *                 type: "PARAMETER_STORE",
 *             },
 *         ],
 *     },
 *     logsConfig: {
 *         cloudwatchLogs: {
 *             groupName: "log-group",
 *             streamName: "log-stream",
 *         },
 *         s3Logs: {
 *             status: "ENABLED",
 *             location: pulumi.interpolate`${exampleBucketV2.id}/build-log`,
 *         },
 *     },
 *     source: {
 *         type: "GITHUB",
 *         location: "https://github.com/mitchellh/packer.git",
 *         gitCloneDepth: 1,
 *         gitSubmodulesConfig: {
 *             fetchSubmodules: true,
 *         },
 *     },
 *     sourceVersion: "master",
 *     vpcConfig: {
 *         vpcId: exampleAwsVpc.id,
 *         subnets: [
 *             example1.id,
 *             example2.id,
 *         ],
 *         securityGroupIds: [
 *             example1AwsSecurityGroup.id,
 *             example2AwsSecurityGroup.id,
 *         ],
 *     },
 *     tags: {
 *         Environment: "Test",
 *     },
 * });
 * const project_with_cache = new aws.codebuild.Project("project-with-cache", {
 *     name: "test-project-cache",
 *     description: "test_codebuild_project_cache",
 *     buildTimeout: 5,
 *     queuedTimeout: 5,
 *     serviceRole: exampleRole.arn,
 *     artifacts: {
 *         type: "NO_ARTIFACTS",
 *     },
 *     cache: {
 *         type: "LOCAL",
 *         modes: [
 *             "LOCAL_DOCKER_LAYER_CACHE",
 *             "LOCAL_SOURCE_CACHE",
 *         ],
 *     },
 *     environment: {
 *         computeType: "BUILD_GENERAL1_SMALL",
 *         image: "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *         type: "LINUX_CONTAINER",
 *         imagePullCredentialsType: "CODEBUILD",
 *         environmentVariables: [{
 *             name: "SOME_KEY1",
 *             value: "SOME_VALUE1",
 *         }],
 *     },
 *     source: {
 *         type: "GITHUB",
 *         location: "https://github.com/mitchellh/packer.git",
 *         gitCloneDepth: 1,
 *     },
 *     tags: {
 *         Environment: "Test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket="example")
 * example_bucket_acl_v2 = aws.s3.BucketAclV2("example",
 *     bucket=example_bucket_v2.id,
 *     acl="private")
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["codebuild&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="example",
 *     assume_role_policy=assume_role.json)
 * example = pulumi.Output.all(example_bucket_v2.arn, example_bucket_v2.arn).apply(lambda exampleBucketV2Arn, exampleBucketV2Arn1: aws.iam.get_policy_document_output(statements=[
 *     {
 *         "effect": "Allow",
 *         "actions": [
 *             "logs:CreateLogGroup",
 *             "logs:CreateLogStream",
 *             "logs:PutLogEvents",
 *         ],
 *         "resources": ["*"],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": [
 *             "ec2:CreateNetworkInterface",
 *             "ec2:DescribeDhcpOptions",
 *             "ec2:DescribeNetworkInterfaces",
 *             "ec2:DeleteNetworkInterface",
 *             "ec2:DescribeSubnets",
 *             "ec2:DescribeSecurityGroups",
 *             "ec2:DescribeVpcs",
 *         ],
 *         "resources": ["*"],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": ["ec2:CreateNetworkInterfacePermission"],
 *         "resources": ["arn:aws:ec2:us-east-1:123456789012:network-interface/*"],
 *         "conditions": [
 *             {
 *                 "test": "StringEquals",
 *                 "variable": "ec2:Subnet",
 *                 "values": [
 *                     example1["arn"],
 *                     example2["arn"],
 *                 ],
 *             },
 *             {
 *                 "test": "StringEquals",
 *                 "variable": "ec2:AuthorizedService",
 *                 "values": ["codebuild&#46;amazonaws&#46;com"],
 *             },
 *         ],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": ["s3:*"],
 *         "resources": [
 *             example_bucket_v2_arn,
 *             f"{example_bucket_v2_arn1}/*",
 *         ],
 *     },
 * ]))
 * example_role_policy = aws.iam.RolePolicy("example",
 *     role=example_role.name,
 *     policy=example.json)
 * example_project = aws.codebuild.Project("example",
 *     name="test-project",
 *     description="test_codebuild_project",
 *     build_timeout=5,
 *     service_role=example_role.arn,
 *     artifacts={
 *         "type": "NO_ARTIFACTS",
 *     },
 *     cache={
 *         "type": "S3",
 *         "location": example_bucket_v2.bucket,
 *     },
 *     environment={
 *         "compute_type": "BUILD_GENERAL1_SMALL",
 *         "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *         "type": "LINUX_CONTAINER",
 *         "image_pull_credentials_type": "CODEBUILD",
 *         "environment_variables": [
 *             {
 *                 "name": "SOME_KEY1",
 *                 "value": "SOME_VALUE1",
 *             },
 *             {
 *                 "name": "SOME_KEY2",
 *                 "value": "SOME_VALUE2",
 *                 "type": "PARAMETER_STORE",
 *             },
 *         ],
 *     },
 *     logs_config={
 *         "cloudwatch_logs": {
 *             "group_name": "log-group",
 *             "stream_name": "log-stream",
 *         },
 *         "s3_logs": {
 *             "status": "ENABLED",
 *             "location": example_bucket_v2.id.apply(lambda id: f"{id}/build-log"),
 *         },
 *     },
 *     source={
 *         "type": "GITHUB",
 *         "location": "https://github.com/mitchellh/packer.git",
 *         "git_clone_depth": 1,
 *         "git_submodules_config": {
 *             "fetch_submodules": True,
 *         },
 *     },
 *     source_version="master",
 *     vpc_config={
 *         "vpc_id": example_aws_vpc["id"],
 *         "subnets": [
 *             example1["id"],
 *             example2["id"],
 *         ],
 *         "security_group_ids": [
 *             example1_aws_security_group["id"],
 *             example2_aws_security_group["id"],
 *         ],
 *     },
 *     tags={
 *         "Environment": "Test",
 *     })
 * project_with_cache = aws.codebuild.Project("project-with-cache",
 *     name="test-project-cache",
 *     description="test_codebuild_project_cache",
 *     build_timeout=5,
 *     queued_timeout=5,
 *     service_role=example_role.arn,
 *     artifacts={
 *         "type": "NO_ARTIFACTS",
 *     },
 *     cache={
 *         "type": "LOCAL",
 *         "modes": [
 *             "LOCAL_DOCKER_LAYER_CACHE",
 *             "LOCAL_SOURCE_CACHE",
 *         ],
 *     },
 *     environment={
 *         "compute_type": "BUILD_GENERAL1_SMALL",
 *         "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *         "type": "LINUX_CONTAINER",
 *         "image_pull_credentials_type": "CODEBUILD",
 *         "environment_variables": [{
 *             "name": "SOME_KEY1",
 *             "value": "SOME_VALUE1",
 *         }],
 *     },
 *     source={
 *         "type": "GITHUB",
 *         "location": "https://github.com/mitchellh/packer.git",
 *         "git_clone_depth": 1,
 *     },
 *     tags={
 *         "Environment": "Test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleBucketAclV2 = new Aws.S3.BucketAclV2("example", new()
 *     {
 *         Bucket = exampleBucketV2.Id,
 *         Acl = "private",
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "codebuild.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:CreateNetworkInterface",
 *                     "ec2:DescribeDhcpOptions",
 *                     "ec2:DescribeNetworkInterfaces",
 *                     "ec2:DeleteNetworkInterface",
 *                     "ec2:DescribeSubnets",
 *                     "ec2:DescribeSecurityGroups",
 *                     "ec2:DescribeVpcs",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:CreateNetworkInterfacePermission",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:ec2:us-east-1:123456789012:network-interface/*",
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "ec2:Subnet",
 *                         Values = new[]
 *                         {
 *                             example1.Arn,
 *                             example2.Arn,
 *                         },
 *                     },
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "ec2:AuthorizedService",
 *                         Values = new[]
 *                         {
 *                             "codebuild.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "s3:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleBucketV2.Arn,
 *                     $"{exampleBucketV2.Arn}/*",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRolePolicy = new Aws.Iam.RolePolicy("example", new()
 *     {
 *         Role = exampleRole.Name,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleProject = new Aws.CodeBuild.Project("example", new()
 *     {
 *         Name = "test-project",
 *         Description = "test_codebuild_project",
 *         BuildTimeout = 5,
 *         ServiceRole = exampleRole.Arn,
 *         Artifacts = new Aws.CodeBuild.Inputs.ProjectArtifactsArgs
 *         {
 *             Type = "NO_ARTIFACTS",
 *         },
 *         Cache = new Aws.CodeBuild.Inputs.ProjectCacheArgs
 *         {
 *             Type = "S3",
 *             Location = exampleBucketV2.Bucket,
 *         },
 *         Environment = new Aws.CodeBuild.Inputs.ProjectEnvironmentArgs
 *         {
 *             ComputeType = "BUILD_GENERAL1_SMALL",
 *             Image = "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *             Type = "LINUX_CONTAINER",
 *             ImagePullCredentialsType = "CODEBUILD",
 *             EnvironmentVariables = new[]
 *             {
 *                 new Aws.CodeBuild.Inputs.ProjectEnvironmentEnvironmentVariableArgs
 *                 {
 *                     Name = "SOME_KEY1",
 *                     Value = "SOME_VALUE1",
 *                 },
 *                 new Aws.CodeBuild.Inputs.ProjectEnvironmentEnvironmentVariableArgs
 *                 {
 *                     Name = "SOME_KEY2",
 *                     Value = "SOME_VALUE2",
 *                     Type = "PARAMETER_STORE",
 *                 },
 *             },
 *         },
 *         LogsConfig = new Aws.CodeBuild.Inputs.ProjectLogsConfigArgs
 *         {
 *             CloudwatchLogs = new Aws.CodeBuild.Inputs.ProjectLogsConfigCloudwatchLogsArgs
 *             {
 *                 GroupName = "log-group",
 *                 StreamName = "log-stream",
 *             },
 *             S3Logs = new Aws.CodeBuild.Inputs.ProjectLogsConfigS3LogsArgs
 *             {
 *                 Status = "ENABLED",
 *                 Location = exampleBucketV2.Id.Apply(id => $"{id}/build-log"),
 *             },
 *         },
 *         Source = new Aws.CodeBuild.Inputs.ProjectSourceArgs
 *         {
 *             Type = "GITHUB",
 *             Location = "https://github.com/mitchellh/packer.git",
 *             GitCloneDepth = 1,
 *             GitSubmodulesConfig = new Aws.CodeBuild.Inputs.ProjectSourceGitSubmodulesConfigArgs
 *             {
 *                 FetchSubmodules = true,
 *             },
 *         },
 *         SourceVersion = "master",
 *         VpcConfig = new Aws.CodeBuild.Inputs.ProjectVpcConfigArgs
 *         {
 *             VpcId = exampleAwsVpc.Id,
 *             Subnets = new[]
 *             {
 *                 example1.Id,
 *                 example2.Id,
 *             },
 *             SecurityGroupIds = new[]
 *             {
 *                 example1AwsSecurityGroup.Id,
 *                 example2AwsSecurityGroup.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "Test" },
 *         },
 *     });
 *     var project_with_cache = new Aws.CodeBuild.Project("project-with-cache", new()
 *     {
 *         Name = "test-project-cache",
 *         Description = "test_codebuild_project_cache",
 *         BuildTimeout = 5,
 *         QueuedTimeout = 5,
 *         ServiceRole = exampleRole.Arn,
 *         Artifacts = new Aws.CodeBuild.Inputs.ProjectArtifactsArgs
 *         {
 *             Type = "NO_ARTIFACTS",
 *         },
 *         Cache = new Aws.CodeBuild.Inputs.ProjectCacheArgs
 *         {
 *             Type = "LOCAL",
 *             Modes = new[]
 *             {
 *                 "LOCAL_DOCKER_LAYER_CACHE",
 *                 "LOCAL_SOURCE_CACHE",
 *             },
 *         },
 *         Environment = new Aws.CodeBuild.Inputs.ProjectEnvironmentArgs
 *         {
 *             ComputeType = "BUILD_GENERAL1_SMALL",
 *             Image = "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *             Type = "LINUX_CONTAINER",
 *             ImagePullCredentialsType = "CODEBUILD",
 *             EnvironmentVariables = new[]
 *             {
 *                 new Aws.CodeBuild.Inputs.ProjectEnvironmentEnvironmentVariableArgs
 *                 {
 *                     Name = "SOME_KEY1",
 *                     Value = "SOME_VALUE1",
 *                 },
 *             },
 *         },
 *         Source = new Aws.CodeBuild.Inputs.ProjectSourceArgs
 *         {
 *             Type = "GITHUB",
 *             Location = "https://github.com/mitchellh/packer.git",
 *             GitCloneDepth = 1,
 *         },
 *         Tags =
 *         {
 *             { "Environment", "Test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codebuild"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * Bucket: pulumi.String("example"),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = s3.NewBucketAclV2(ctx, "example", &s3.BucketAclV2Args{
 * Bucket: exampleBucketV2.ID(),
 * Acl: pulumi.String("private"),
 * })
 * if err != nil {
 * return err
 * }
 * assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: pulumi.StringRef("Allow"),
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "Service",
 * Identifiers: []string{
 * "codebuild.amazonaws.com",
 * },
 * },
 * },
 * Actions: []string{
 * "sts:AssumeRole",
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * Name: pulumi.String("example"),
 * AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * })
 * if err != nil {
 * return err
 * }
 * example := pulumi.All(exampleBucketV2.Arn,exampleBucketV2.Arn).ApplyT(func(_args []interface{}) (iam.GetPolicyDocumentResult, error) {
 * exampleBucketV2Arn := _args[0].(string)
 * exampleBucketV2Arn1 := _args[1].(string)
 * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "logs:CreateLogGroup",
 * "logs:CreateLogStream",
 * "logs:PutLogEvents",
 * },
 * Resources: []string{
 * "*",
 * },
 * },
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "ec2:CreateNetworkInterface",
 * "ec2:DescribeDhcpOptions",
 * "ec2:DescribeNetworkInterfaces",
 * "ec2:DeleteNetworkInterface",
 * "ec2:DescribeSubnets",
 * "ec2:DescribeSecurityGroups",
 * "ec2:DescribeVpcs",
 * },
 * Resources: []string{
 * "*",
 * },
 * },
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "ec2:CreateNetworkInterfacePermission",
 * },
 * Resources: []string{
 * "arn:aws:ec2:us-east-1:123456789012:network-interface/*",
 * },
 * Conditions: []iam.GetPolicyDocumentStatementCondition{
 * {
 * Test: "StringEquals",
 * Variable: "ec2:Subnet",
 * Values: interface{}{
 * example1.Arn,
 * example2.Arn,
 * },
 * },
 * {
 * Test: "StringEquals",
 * Variable: "ec2:AuthorizedService",
 * Values: []string{
 * "codebuild.amazonaws.com",
 * },
 * },
 * },
 * },
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "s3:*",
 * },
 * Resources: []string{
 * exampleBucketV2Arn,
 * fmt.Sprintf("%v/*", exampleBucketV2Arn1),
 * },
 * },
 * },
 * }, nil))), nil
 * }).(iam.GetPolicyDocumentResultOutput)
 * _, err = iam.NewRolePolicy(ctx, "example", &iam.RolePolicyArgs{
 * Role: exampleRole.Name,
 * Policy: pulumi.String(example.ApplyT(func(example iam.GetPolicyDocumentResult) (*string, error) {
 * return &example.Json, nil
 * }).(pulumi.StringPtrOutput)),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = codebuild.NewProject(ctx, "example", &codebuild.ProjectArgs{
 * Name: pulumi.String("test-project"),
 * Description: pulumi.String("test_codebuild_project"),
 * BuildTimeout: pulumi.Int(5),
 * ServiceRole: exampleRole.Arn,
 * Artifacts: &codebuild.ProjectArtifactsArgs{
 * Type: pulumi.String("NO_ARTIFACTS"),
 * },
 * Cache: &codebuild.ProjectCacheArgs{
 * Type: pulumi.String("S3"),
 * Location: exampleBucketV2.Bucket,
 * },
 * Environment: &codebuild.ProjectEnvironmentArgs{
 * ComputeType: pulumi.String("BUILD_GENERAL1_SMALL"),
 * Image: pulumi.String("aws/codebuild/amazonlinux2-x86_64-standard:4.0"),
 * Type: pulumi.String("LINUX_CONTAINER"),
 * ImagePullCredentialsType: pulumi.String("CODEBUILD"),
 * EnvironmentVariables: codebuild.ProjectEnvironmentEnvironmentVariableArray{
 * &codebuild.ProjectEnvironmentEnvironmentVariableArgs{
 * Name: pulumi.String("SOME_KEY1"),
 * Value: pulumi.String("SOME_VALUE1"),
 * },
 * &codebuild.ProjectEnvironmentEnvironmentVariableArgs{
 * Name: pulumi.String("SOME_KEY2"),
 * Value: pulumi.String("SOME_VALUE2"),
 * Type: pulumi.String("PARAMETER_STORE"),
 * },
 * },
 * },
 * LogsConfig: &codebuild.ProjectLogsConfigArgs{
 * CloudwatchLogs: &codebuild.ProjectLogsConfigCloudwatchLogsArgs{
 * GroupName: pulumi.String("log-group"),
 * StreamName: pulumi.String("log-stream"),
 * },
 * S3Logs: &codebuild.ProjectLogsConfigS3LogsArgs{
 * Status: pulumi.String("ENABLED"),
 * Location: exampleBucketV2.ID().ApplyT(func(id string) (string, error) {
 * return fmt.Sprintf("%v/build-log", id), nil
 * }).(pulumi.StringOutput),
 * },
 * },
 * Source: &codebuild.ProjectSourceArgs{
 * Type: pulumi.String("GITHUB"),
 * Location: pulumi.String("https://github.com/mitchellh/packer.git"),
 * GitCloneDepth: pulumi.Int(1),
 * GitSubmodulesConfig: &codebuild.ProjectSourceGitSubmodulesConfigArgs{
 * FetchSubmodules: pulumi.Bool(true),
 * },
 * },
 * SourceVersion: pulumi.String("master"),
 * VpcConfig: &codebuild.ProjectVpcConfigArgs{
 * VpcId: pulumi.Any(exampleAwsVpc.Id),
 * Subnets: pulumi.StringArray{
 * example1.Id,
 * example2.Id,
 * },
 * SecurityGroupIds: pulumi.StringArray{
 * example1AwsSecurityGroup.Id,
 * example2AwsSecurityGroup.Id,
 * },
 * },
 * Tags: pulumi.StringMap{
 * "Environment": pulumi.String("Test"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * _, err = codebuild.NewProject(ctx, "project-with-cache", &codebuild.ProjectArgs{
 * Name: pulumi.String("test-project-cache"),
 * Description: pulumi.String("test_codebuild_project_cache"),
 * BuildTimeout: pulumi.Int(5),
 * QueuedTimeout: pulumi.Int(5),
 * ServiceRole: exampleRole.Arn,
 * Artifacts: &codebuild.ProjectArtifactsArgs{
 * Type: pulumi.String("NO_ARTIFACTS"),
 * },
 * Cache: &codebuild.ProjectCacheArgs{
 * Type: pulumi.String("LOCAL"),
 * Modes: pulumi.StringArray{
 * pulumi.String("LOCAL_DOCKER_LAYER_CACHE"),
 * pulumi.String("LOCAL_SOURCE_CACHE"),
 * },
 * },
 * Environment: &codebuild.ProjectEnvironmentArgs{
 * ComputeType: pulumi.String("BUILD_GENERAL1_SMALL"),
 * Image: pulumi.String("aws/codebuild/amazonlinux2-x86_64-standard:4.0"),
 * Type: pulumi.String("LINUX_CONTAINER"),
 * ImagePullCredentialsType: pulumi.String("CODEBUILD"),
 * EnvironmentVariables: codebuild.ProjectEnvironmentEnvironmentVariableArray{
 * &codebuild.ProjectEnvironmentEnvironmentVariableArgs{
 * Name: pulumi.String("SOME_KEY1"),
 * Value: pulumi.String("SOME_VALUE1"),
 * },
 * },
 * },
 * Source: &codebuild.ProjectSourceArgs{
 * Type: pulumi.String("GITHUB"),
 * Location: pulumi.String("https://github.com/mitchellh/packer.git"),
 * GitCloneDepth: pulumi.Int(1),
 * },
 * Tags: pulumi.StringMap{
 * "Environment": pulumi.String("Test"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.codebuild.Project;
 * import com.pulumi.aws.codebuild.ProjectArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectCacheArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigCloudwatchLogsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigS3LogsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectSourceArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectSourceGitSubmodulesConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codebuild.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "logs:CreateLogGroup",
 *                         "logs:CreateLogStream",
 *                         "logs:PutLogEvents")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "ec2:CreateNetworkInterface",
 *                         "ec2:DescribeDhcpOptions",
 *                         "ec2:DescribeNetworkInterfaces",
 *                         "ec2:DeleteNetworkInterface",
 *                         "ec2:DescribeSubnets",
 *                         "ec2:DescribeSecurityGroups",
 *                         "ec2:DescribeVpcs")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ec2:CreateNetworkInterfacePermission")
 *                     .resources("arn:aws:ec2:us-east-1:123456789012:network-interface/*")
 *                     .conditions(
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("ec2:Subnet")
 *                             .values(
 *                                 example1.arn(),
 *                                 example2.arn())
 *                             .build(),
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("ec2:AuthorizedService")
 *                             .values("codebuild.amazonaws.com")
 *                             .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("s3:*")
 *                     .resources(
 *                         exampleBucketV2.arn(),
 *                         exampleBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.name())
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(example -> example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleProject = new Project("exampleProject", ProjectArgs.builder()
 *             .name("test-project")
 *             .description("test_codebuild_project")
 *             .buildTimeout(5)
 *             .serviceRole(exampleRole.arn())
 *             .artifacts(ProjectArtifactsArgs.builder()
 *                 .type("NO_ARTIFACTS")
 *                 .build())
 *             .cache(ProjectCacheArgs.builder()
 *                 .type("S3")
 *                 .location(exampleBucketV2.bucket())
 *                 .build())
 *             .environment(ProjectEnvironmentArgs.builder()
 *                 .computeType("BUILD_GENERAL1_SMALL")
 *                 .image("aws/codebuild/amazonlinux2-x86_64-standard:4.0")
 *                 .type("LINUX_CONTAINER")
 *                 .imagePullCredentialsType("CODEBUILD")
 *                 .environmentVariables(
 *                     ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                         .name("SOME_KEY1")
 *                         .value("SOME_VALUE1")
 *                         .build(),
 *                     ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                         .name("SOME_KEY2")
 *                         .value("SOME_VALUE2")
 *                         .type("PARAMETER_STORE")
 *                         .build())
 *                 .build())
 *             .logsConfig(ProjectLogsConfigArgs.builder()
 *                 .cloudwatchLogs(ProjectLogsConfigCloudwatchLogsArgs.builder()
 *                     .groupName("log-group")
 *                     .streamName("log-stream")
 *                     .build())
 *                 .s3Logs(ProjectLogsConfigS3LogsArgs.builder()
 *                     .status("ENABLED")
 *                     .location(exampleBucketV2.id().applyValue(id -> String.format("%s/build-log", id)))
 *                     .build())
 *                 .build())
 *             .source(ProjectSourceArgs.builder()
 *                 .type("GITHUB")
 *                 .location("https://github.com/mitchellh/packer.git")
 *                 .gitCloneDepth(1)
 *                 .gitSubmodulesConfig(ProjectSourceGitSubmodulesConfigArgs.builder()
 *                     .fetchSubmodules(true)
 *                     .build())
 *                 .build())
 *             .sourceVersion("master")
 *             .vpcConfig(ProjectVpcConfigArgs.builder()
 *                 .vpcId(exampleAwsVpc.id())
 *                 .subnets(
 *                     example1.id(),
 *                     example2.id())
 *                 .securityGroupIds(
 *                     example1AwsSecurityGroup.id(),
 *                     example2AwsSecurityGroup.id())
 *                 .build())
 *             .tags(Map.of("Environment", "Test"))
 *             .build());
 *         var project_with_cache = new Project("project-with-cache", ProjectArgs.builder()
 *             .name("test-project-cache")
 *             .description("test_codebuild_project_cache")
 *             .buildTimeout(5)
 *             .queuedTimeout(5)
 *             .serviceRole(exampleRole.arn())
 *             .artifacts(ProjectArtifactsArgs.builder()
 *                 .type("NO_ARTIFACTS")
 *                 .build())
 *             .cache(ProjectCacheArgs.builder()
 *                 .type("LOCAL")
 *                 .modes(
 *                     "LOCAL_DOCKER_LAYER_CACHE",
 *                     "LOCAL_SOURCE_CACHE")
 *                 .build())
 *             .environment(ProjectEnvironmentArgs.builder()
 *                 .computeType("BUILD_GENERAL1_SMALL")
 *                 .image("aws/codebuild/amazonlinux2-x86_64-standard:4.0")
 *                 .type("LINUX_CONTAINER")
 *                 .imagePullCredentialsType("CODEBUILD")
 *                 .environmentVariables(ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                     .name("SOME_KEY1")
 *                     .value("SOME_VALUE1")
 *                     .build())
 *                 .build())
 *             .source(ProjectSourceArgs.builder()
 *                 .type("GITHUB")
 *                 .location("https://github.com/mitchellh/packer.git")
 *                 .gitCloneDepth(1)
 *                 .build())
 *             .tags(Map.of("Environment", "Test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: example
 *   exampleBucketAclV2:
 *     type: aws:s3:BucketAclV2
 *     name: example
 *     properties:
 *       bucket: ${exampleBucketV2.id}
 *       acl: private
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example
 *       assumeRolePolicy: ${assumeRole.json}
 *   exampleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: example
 *     properties:
 *       role: ${exampleRole.name}
 *       policy: ${example.json}
 *   exampleProject:
 *     type: aws:codebuild:Project
 *     name: example
 *     properties:
 *       name: test-project
 *       description: test_codebuild_project
 *       buildTimeout: 5
 *       serviceRole: ${exampleRole.arn}
 *       artifacts:
 *         type: NO_ARTIFACTS
 *       cache:
 *         type: S3
 *         location: ${exampleBucketV2.bucket}
 *       environment:
 *         computeType: BUILD_GENERAL1_SMALL
 *         image: aws/codebuild/amazonlinux2-x86_64-standard:4.0
 *         type: LINUX_CONTAINER
 *         imagePullCredentialsType: CODEBUILD
 *         environmentVariables:
 *           - name: SOME_KEY1
 *             value: SOME_VALUE1
 *           - name: SOME_KEY2
 *             value: SOME_VALUE2
 *             type: PARAMETER_STORE
 *       logsConfig:
 *         cloudwatchLogs:
 *           groupName: log-group
 *           streamName: log-stream
 *         s3Logs:
 *           status: ENABLED
 *           location: ${exampleBucketV2.id}/build-log
 *       source:
 *         type: GITHUB
 *         location: https://github.com/mitchellh/packer.git
 *         gitCloneDepth: 1
 *         gitSubmodulesConfig:
 *           fetchSubmodules: true
 *       sourceVersion: master
 *       vpcConfig:
 *         vpcId: ${exampleAwsVpc.id}
 *         subnets:
 *           - ${example1.id}
 *           - ${example2.id}
 *         securityGroupIds:
 *           - ${example1AwsSecurityGroup.id}
 *           - ${example2AwsSecurityGroup.id}
 *       tags:
 *         Environment: Test
 *   project-with-cache:
 *     type: aws:codebuild:Project
 *     properties:
 *       name: test-project-cache
 *       description: test_codebuild_project_cache
 *       buildTimeout: 5
 *       queuedTimeout: 5
 *       serviceRole: ${exampleRole.arn}
 *       artifacts:
 *         type: NO_ARTIFACTS
 *       cache:
 *         type: LOCAL
 *         modes:
 *           - LOCAL_DOCKER_LAYER_CACHE
 *           - LOCAL_SOURCE_CACHE
 *       environment:
 *         computeType: BUILD_GENERAL1_SMALL
 *         image: aws/codebuild/amazonlinux2-x86_64-standard:4.0
 *         type: LINUX_CONTAINER
 *         imagePullCredentialsType: CODEBUILD
 *         environmentVariables:
 *           - name: SOME_KEY1
 *             value: SOME_VALUE1
 *       source:
 *         type: GITHUB
 *         location: https://github.com/mitchellh/packer.git
 *         gitCloneDepth: 1
 *       tags:
 *         Environment: Test
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - codebuild.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - logs:CreateLogGroup
 *               - logs:CreateLogStream
 *               - logs:PutLogEvents
 *             resources:
 *               - '*'
 *           - effect: Allow
 *             actions:
 *               - ec2:CreateNetworkInterface
 *               - ec2:DescribeDhcpOptions
 *               - ec2:DescribeNetworkInterfaces
 *               - ec2:DeleteNetworkInterface
 *               - ec2:DescribeSubnets
 *               - ec2:DescribeSecurityGroups
 *               - ec2:DescribeVpcs
 *             resources:
 *               - '*'
 *           - effect: Allow
 *             actions:
 *               - ec2:CreateNetworkInterfacePermission
 *             resources:
 *               - arn:aws:ec2:us-east-1:123456789012:network-interface/*
 *             conditions:
 *               - test: StringEquals
 *                 variable: ec2:Subnet
 *                 values:
 *                   - ${example1.arn}
 *                   - ${example2.arn}
 *               - test: StringEquals
 *                 variable: ec2:AuthorizedService
 *                 values:
 *                   - codebuild.amazonaws.com
 *           - effect: Allow
 *             actions:
 *               - s3:*
 *             resources:
 *               - ${exampleBucketV2.arn}
 *               - ${exampleBucketV2.arn}/*
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeBuild Project using the `name`. For example:
 * ```sh
 * $ pulumi import aws:codebuild/project:Project name project-name
 * ```
 * */*/*/*/*/*/*/*/*/*/*/*/
 */
public class Project internal constructor(
    override val javaResource: com.pulumi.aws.codebuild.Project,
) : KotlinCustomResource(javaResource, ProjectMapper) {
    /**
     * ARN of the CodeBuild project.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Configuration block. Detailed below.
     */
    public val artifacts: Output<ProjectArtifacts>
        get() = javaResource.artifacts().applyValue({ args0 ->
            args0.let({ args0 ->
                projectArtifactsToKotlin(args0)
            })
        })

    /**
     * Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
     */
    public val badgeEnabled: Output<Boolean>?
        get() = javaResource.badgeEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * URL of the build badge when `badge_enabled` is enabled.
     */
    public val badgeUrl: Output<String>
        get() = javaResource.badgeUrl().applyValue({ args0 -> args0 })

    /**
     * Defines the batch build options for the project.
     */
    public val buildBatchConfig: Output<ProjectBuildBatchConfig>?
        get() = javaResource.buildBatchConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> projectBuildBatchConfigToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is not available on the `Lambda` compute type.
     */
    public val buildTimeout: Output<Int>?
        get() = javaResource.buildTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val cache: Output<ProjectCache>?
        get() = javaResource.cache().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectCacheToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
     */
    public val concurrentBuildLimit: Output<Int>?
        get() = javaResource.concurrentBuildLimit().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Short description of the project.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
     */
    public val encryptionKey: Output<String>
        get() = javaResource.encryptionKey().applyValue({ args0 -> args0 })

    /**
     * Configuration block. Detailed below.
     */
    public val environment: Output<ProjectEnvironment>
        get() = javaResource.environment().applyValue({ args0 ->
            args0.let({ args0 ->
                projectEnvironmentToKotlin(args0)
            })
        })

    /**
     * A set of file system locations to mount inside the build. File system locations are documented below.
     */
    public val fileSystemLocations: Output<List<ProjectFileSystemLocation>>?
        get() = javaResource.fileSystemLocations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        projectFileSystemLocationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val logsConfig: Output<ProjectLogsConfig>?
        get() = javaResource.logsConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectLogsConfigToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Project's name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
     */
    public val projectVisibility: Output<String>?
        get() = javaResource.projectVisibility().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The project identifier used with the public build APIs.
     */
    public val publicProjectAlias: Output<String>
        get() = javaResource.publicProjectAlias().applyValue({ args0 -> args0 })

    /**
     * Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
     */
    public val queuedTimeout: Output<Int>?
        get() = javaResource.queuedTimeout().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if `project_visibility` is `PUBLIC_READ`.
     */
    public val resourceAccessRole: Output<String>?
        get() = javaResource.resourceAccessRole().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val secondaryArtifacts: Output<List<ProjectSecondaryArtifact>>?
        get() = javaResource.secondaryArtifacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        projectSecondaryArtifactToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val secondarySourceVersions: Output<List<ProjectSecondarySourceVersion>>?
        get() = javaResource.secondarySourceVersions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        projectSecondarySourceVersionToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Configuration block. Detailed below.
     */
    public val secondarySources: Output<List<ProjectSecondarySource>>?
        get() = javaResource.secondarySources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        projectSecondarySourceToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    public val serviceRole: Output<String>
        get() = javaResource.serviceRole().applyValue({ args0 -> args0 })

    /**
     * Configuration block. Detailed below.
     * The following arguments are optional:
     */
    public val source: Output<ProjectSource>
        get() = javaResource.source().applyValue({ args0 ->
            args0.let({ args0 ->
                projectSourceToKotlin(args0)
            })
        })

    /**
     * Version of the build input to be built for this project. If not specified, the latest version is used.
     */
    public val sourceVersion: Output<String>?
        get() = javaResource.sourceVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block. Detailed below.
     */
    public val vpcConfig: Output<ProjectVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    projectVpcConfigToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ProjectMapper : ResourceMapper<Project> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codebuild.Project::class == javaResource::class

    override fun map(javaResource: Resource): Project = Project(
        javaResource as
            com.pulumi.aws.codebuild.Project,
    )
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Project].
 */
public suspend fun project(name: String, block: suspend ProjectResourceBuilder.() -> Unit): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Project].
 * @param name The _unique_ name of the resulting resource.
 */
public fun project(name: String): Project {
    val builder = ProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
