@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.ProjectArgs.builder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectArtifactsArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectArtifactsArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectBuildBatchConfigArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectBuildBatchConfigArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectCacheArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectCacheArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectEnvironmentArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectEnvironmentArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectFileSystemLocationArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectFileSystemLocationArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectLogsConfigArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectLogsConfigArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondaryArtifactArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondaryArtifactArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondarySourceArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondarySourceArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondarySourceVersionArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSecondarySourceVersionArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSourceArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectSourceArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectVpcConfigArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ProjectVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeBuild Project resource. See also the `aws.codebuild.Webhook` resource, which manages the webhook to the source (e.g., the "rebuild every time a code change is pushed" option in the CodeBuild web console).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "example"});
 * const exampleBucketAclV2 = new aws.s3.BucketAclV2("example", {
 *     bucket: exampleBucketV2.id,
 *     acl: "private",
 * });
 * const assumeRole = aws.iam.getPolicyDocument({
 *     statements: [{
 *         effect: "Allow",
 *         principals: [{
 *             type: "Service",
 *             identifiers: ["codebuild&#46;amazonaws&#46;com"],
 *         }],
 *         actions: ["sts:AssumeRole"],
 *     }],
 * });
 * const exampleRole = new aws.iam.Role("example", {
 *     name: "example",
 *     assumeRolePolicy: assumeRole.then(assumeRole => assumeRole.json),
 * });
 * const example = pulumi.all([exampleBucketV2&#46;arn, exampleBucketV2&#46;arn])&#46;apply(([exampleBucketV2Arn, exampleBucketV2Arn1]) => aws.iam.getPolicyDocumentOutput({
 *     statements: [
 *         {
 *             effect: "Allow",
 *             actions: [
 *                 "logs:CreateLogGroup",
 *                 "logs:CreateLogStream",
 *                 "logs:PutLogEvents",
 *             ],
 *             resources: ["*"],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: [
 *                 "ec2:CreateNetworkInterface",
 *                 "ec2:DescribeDhcpOptions",
 *                 "ec2:DescribeNetworkInterfaces",
 *                 "ec2:DeleteNetworkInterface",
 *                 "ec2:DescribeSubnets",
 *                 "ec2:DescribeSecurityGroups",
 *                 "ec2:DescribeVpcs",
 *             ],
 *             resources: ["*"],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: ["ec2:CreateNetworkInterfacePermission"],
 *             resources: ["arn:aws:ec2:us-east-1:123456789012:network-interface/*"],
 *             conditions: [
 *                 {
 *                     test: "StringEquals",
 *                     variable: "ec2:Subnet",
 *                     values: [
 *                         example1.arn,
 *                         example2.arn,
 *                     ],
 *                 },
 *                 {
 *                     test: "StringEquals",
 *                     variable: "ec2:AuthorizedService",
 *                     values: ["codebuild&#46;amazonaws&#46;com"],
 *                 },
 *             ],
 *         },
 *         {
 *             effect: "Allow",
 *             actions: ["s3:*"],
 *             resources: [
 *                 exampleBucketV2Arn,
 *                 `${exampleBucketV2Arn1}/*`,
 *             ],
 *         },
 *     ],
 * }));
 * const exampleRolePolicy = new aws.iam.RolePolicy("example", {
 *     role: exampleRole.name,
 *     policy: example.apply(example => example.json),
 * });
 * const exampleProject = new aws.codebuild.Project("example", {
 *     name: "test-project",
 *     description: "test_codebuild_project",
 *     buildTimeout: 5,
 *     serviceRole: exampleRole.arn,
 *     artifacts: {
 *         type: "NO_ARTIFACTS",
 *     },
 *     cache: {
 *         type: "S3",
 *         location: exampleBucketV2.bucket,
 *     },
 *     environment: {
 *         computeType: "BUILD_GENERAL1_SMALL",
 *         image: "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *         type: "LINUX_CONTAINER",
 *         imagePullCredentialsType: "CODEBUILD",
 *         environmentVariables: [
 *             {
 *                 name: "SOME_KEY1",
 *                 value: "SOME_VALUE1",
 *             },
 *             {
 *                 name: "SOME_KEY2",
 *                 value: "SOME_VALUE2",
 *                 type: "PARAMETER_STORE",
 *             },
 *         ],
 *     },
 *     logsConfig: {
 *         cloudwatchLogs: {
 *             groupName: "log-group",
 *             streamName: "log-stream",
 *         },
 *         s3Logs: {
 *             status: "ENABLED",
 *             location: pulumi.interpolate`${exampleBucketV2.id}/build-log`,
 *         },
 *     },
 *     source: {
 *         type: "GITHUB",
 *         location: "https://github.com/mitchellh/packer.git",
 *         gitCloneDepth: 1,
 *         gitSubmodulesConfig: {
 *             fetchSubmodules: true,
 *         },
 *     },
 *     sourceVersion: "master",
 *     vpcConfig: {
 *         vpcId: exampleAwsVpc.id,
 *         subnets: [
 *             example1.id,
 *             example2.id,
 *         ],
 *         securityGroupIds: [
 *             example1AwsSecurityGroup.id,
 *             example2AwsSecurityGroup.id,
 *         ],
 *     },
 *     tags: {
 *         Environment: "Test",
 *     },
 * });
 * const project_with_cache = new aws.codebuild.Project("project-with-cache", {
 *     name: "test-project-cache",
 *     description: "test_codebuild_project_cache",
 *     buildTimeout: 5,
 *     queuedTimeout: 5,
 *     serviceRole: exampleRole.arn,
 *     artifacts: {
 *         type: "NO_ARTIFACTS",
 *     },
 *     cache: {
 *         type: "LOCAL",
 *         modes: [
 *             "LOCAL_DOCKER_LAYER_CACHE",
 *             "LOCAL_SOURCE_CACHE",
 *         ],
 *     },
 *     environment: {
 *         computeType: "BUILD_GENERAL1_SMALL",
 *         image: "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *         type: "LINUX_CONTAINER",
 *         imagePullCredentialsType: "CODEBUILD",
 *         environmentVariables: [{
 *             name: "SOME_KEY1",
 *             value: "SOME_VALUE1",
 *         }],
 *     },
 *     source: {
 *         type: "GITHUB",
 *         location: "https://github.com/mitchellh/packer.git",
 *         gitCloneDepth: 1,
 *     },
 *     tags: {
 *         Environment: "Test",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket="example")
 * example_bucket_acl_v2 = aws.s3.BucketAclV2("example",
 *     bucket=example_bucket_v2.id,
 *     acl="private")
 * assume_role = aws.iam.get_policy_document(statements=[{
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "Service",
 *         "identifiers": ["codebuild&#46;amazonaws&#46;com"],
 *     }],
 *     "actions": ["sts:AssumeRole"],
 * }])
 * example_role = aws.iam.Role("example",
 *     name="example",
 *     assume_role_policy=assume_role.json)
 * example = pulumi.Output.all(example_bucket_v2.arn, example_bucket_v2.arn).apply(lambda exampleBucketV2Arn, exampleBucketV2Arn1: aws.iam.get_policy_document_output(statements=[
 *     {
 *         "effect": "Allow",
 *         "actions": [
 *             "logs:CreateLogGroup",
 *             "logs:CreateLogStream",
 *             "logs:PutLogEvents",
 *         ],
 *         "resources": ["*"],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": [
 *             "ec2:CreateNetworkInterface",
 *             "ec2:DescribeDhcpOptions",
 *             "ec2:DescribeNetworkInterfaces",
 *             "ec2:DeleteNetworkInterface",
 *             "ec2:DescribeSubnets",
 *             "ec2:DescribeSecurityGroups",
 *             "ec2:DescribeVpcs",
 *         ],
 *         "resources": ["*"],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": ["ec2:CreateNetworkInterfacePermission"],
 *         "resources": ["arn:aws:ec2:us-east-1:123456789012:network-interface/*"],
 *         "conditions": [
 *             {
 *                 "test": "StringEquals",
 *                 "variable": "ec2:Subnet",
 *                 "values": [
 *                     example1["arn"],
 *                     example2["arn"],
 *                 ],
 *             },
 *             {
 *                 "test": "StringEquals",
 *                 "variable": "ec2:AuthorizedService",
 *                 "values": ["codebuild&#46;amazonaws&#46;com"],
 *             },
 *         ],
 *     },
 *     {
 *         "effect": "Allow",
 *         "actions": ["s3:*"],
 *         "resources": [
 *             example_bucket_v2_arn,
 *             f"{example_bucket_v2_arn1}/*",
 *         ],
 *     },
 * ]))
 * example_role_policy = aws.iam.RolePolicy("example",
 *     role=example_role.name,
 *     policy=example.json)
 * example_project = aws.codebuild.Project("example",
 *     name="test-project",
 *     description="test_codebuild_project",
 *     build_timeout=5,
 *     service_role=example_role.arn,
 *     artifacts={
 *         "type": "NO_ARTIFACTS",
 *     },
 *     cache={
 *         "type": "S3",
 *         "location": example_bucket_v2.bucket,
 *     },
 *     environment={
 *         "compute_type": "BUILD_GENERAL1_SMALL",
 *         "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *         "type": "LINUX_CONTAINER",
 *         "image_pull_credentials_type": "CODEBUILD",
 *         "environment_variables": [
 *             {
 *                 "name": "SOME_KEY1",
 *                 "value": "SOME_VALUE1",
 *             },
 *             {
 *                 "name": "SOME_KEY2",
 *                 "value": "SOME_VALUE2",
 *                 "type": "PARAMETER_STORE",
 *             },
 *         ],
 *     },
 *     logs_config={
 *         "cloudwatch_logs": {
 *             "group_name": "log-group",
 *             "stream_name": "log-stream",
 *         },
 *         "s3_logs": {
 *             "status": "ENABLED",
 *             "location": example_bucket_v2.id.apply(lambda id: f"{id}/build-log"),
 *         },
 *     },
 *     source={
 *         "type": "GITHUB",
 *         "location": "https://github.com/mitchellh/packer.git",
 *         "git_clone_depth": 1,
 *         "git_submodules_config": {
 *             "fetch_submodules": True,
 *         },
 *     },
 *     source_version="master",
 *     vpc_config={
 *         "vpc_id": example_aws_vpc["id"],
 *         "subnets": [
 *             example1["id"],
 *             example2["id"],
 *         ],
 *         "security_group_ids": [
 *             example1_aws_security_group["id"],
 *             example2_aws_security_group["id"],
 *         ],
 *     },
 *     tags={
 *         "Environment": "Test",
 *     })
 * project_with_cache = aws.codebuild.Project("project-with-cache",
 *     name="test-project-cache",
 *     description="test_codebuild_project_cache",
 *     build_timeout=5,
 *     queued_timeout=5,
 *     service_role=example_role.arn,
 *     artifacts={
 *         "type": "NO_ARTIFACTS",
 *     },
 *     cache={
 *         "type": "LOCAL",
 *         "modes": [
 *             "LOCAL_DOCKER_LAYER_CACHE",
 *             "LOCAL_SOURCE_CACHE",
 *         ],
 *     },
 *     environment={
 *         "compute_type": "BUILD_GENERAL1_SMALL",
 *         "image": "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *         "type": "LINUX_CONTAINER",
 *         "image_pull_credentials_type": "CODEBUILD",
 *         "environment_variables": [{
 *             "name": "SOME_KEY1",
 *             "value": "SOME_VALUE1",
 *         }],
 *     },
 *     source={
 *         "type": "GITHUB",
 *         "location": "https://github.com/mitchellh/packer.git",
 *         "git_clone_depth": 1,
 *     },
 *     tags={
 *         "Environment": "Test",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "example",
 *     });
 *     var exampleBucketAclV2 = new Aws.S3.BucketAclV2("example", new()
 *     {
 *         Bucket = exampleBucketV2.Id,
 *         Acl = "private",
 *     });
 *     var assumeRole = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "Service",
 *                         Identifiers = new[]
 *                         {
 *                             "codebuild.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "sts:AssumeRole",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRole = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "example",
 *         AssumeRolePolicy = assumeRole.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "logs:CreateLogGroup",
 *                     "logs:CreateLogStream",
 *                     "logs:PutLogEvents",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:CreateNetworkInterface",
 *                     "ec2:DescribeDhcpOptions",
 *                     "ec2:DescribeNetworkInterfaces",
 *                     "ec2:DeleteNetworkInterface",
 *                     "ec2:DescribeSubnets",
 *                     "ec2:DescribeSecurityGroups",
 *                     "ec2:DescribeVpcs",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "ec2:CreateNetworkInterfacePermission",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:ec2:us-east-1:123456789012:network-interface/*",
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "ec2:Subnet",
 *                         Values = new[]
 *                         {
 *                             example1.Arn,
 *                             example2.Arn,
 *                         },
 *                     },
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "StringEquals",
 *                         Variable = "ec2:AuthorizedService",
 *                         Values = new[]
 *                         {
 *                             "codebuild.amazonaws.com",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Effect = "Allow",
 *                 Actions = new[]
 *                 {
 *                     "s3:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     exampleBucketV2.Arn,
 *                     $"{exampleBucketV2.Arn}/*",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleRolePolicy = new Aws.Iam.RolePolicy("example", new()
 *     {
 *         Role = exampleRole.Name,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleProject = new Aws.CodeBuild.Project("example", new()
 *     {
 *         Name = "test-project",
 *         Description = "test_codebuild_project",
 *         BuildTimeout = 5,
 *         ServiceRole = exampleRole.Arn,
 *         Artifacts = new Aws.CodeBuild.Inputs.ProjectArtifactsArgs
 *         {
 *             Type = "NO_ARTIFACTS",
 *         },
 *         Cache = new Aws.CodeBuild.Inputs.ProjectCacheArgs
 *         {
 *             Type = "S3",
 *             Location = exampleBucketV2.Bucket,
 *         },
 *         Environment = new Aws.CodeBuild.Inputs.ProjectEnvironmentArgs
 *         {
 *             ComputeType = "BUILD_GENERAL1_SMALL",
 *             Image = "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *             Type = "LINUX_CONTAINER",
 *             ImagePullCredentialsType = "CODEBUILD",
 *             EnvironmentVariables = new[]
 *             {
 *                 new Aws.CodeBuild.Inputs.ProjectEnvironmentEnvironmentVariableArgs
 *                 {
 *                     Name = "SOME_KEY1",
 *                     Value = "SOME_VALUE1",
 *                 },
 *                 new Aws.CodeBuild.Inputs.ProjectEnvironmentEnvironmentVariableArgs
 *                 {
 *                     Name = "SOME_KEY2",
 *                     Value = "SOME_VALUE2",
 *                     Type = "PARAMETER_STORE",
 *                 },
 *             },
 *         },
 *         LogsConfig = new Aws.CodeBuild.Inputs.ProjectLogsConfigArgs
 *         {
 *             CloudwatchLogs = new Aws.CodeBuild.Inputs.ProjectLogsConfigCloudwatchLogsArgs
 *             {
 *                 GroupName = "log-group",
 *                 StreamName = "log-stream",
 *             },
 *             S3Logs = new Aws.CodeBuild.Inputs.ProjectLogsConfigS3LogsArgs
 *             {
 *                 Status = "ENABLED",
 *                 Location = exampleBucketV2.Id.Apply(id => $"{id}/build-log"),
 *             },
 *         },
 *         Source = new Aws.CodeBuild.Inputs.ProjectSourceArgs
 *         {
 *             Type = "GITHUB",
 *             Location = "https://github.com/mitchellh/packer.git",
 *             GitCloneDepth = 1,
 *             GitSubmodulesConfig = new Aws.CodeBuild.Inputs.ProjectSourceGitSubmodulesConfigArgs
 *             {
 *                 FetchSubmodules = true,
 *             },
 *         },
 *         SourceVersion = "master",
 *         VpcConfig = new Aws.CodeBuild.Inputs.ProjectVpcConfigArgs
 *         {
 *             VpcId = exampleAwsVpc.Id,
 *             Subnets = new[]
 *             {
 *                 example1.Id,
 *                 example2.Id,
 *             },
 *             SecurityGroupIds = new[]
 *             {
 *                 example1AwsSecurityGroup.Id,
 *                 example2AwsSecurityGroup.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Environment", "Test" },
 *         },
 *     });
 *     var project_with_cache = new Aws.CodeBuild.Project("project-with-cache", new()
 *     {
 *         Name = "test-project-cache",
 *         Description = "test_codebuild_project_cache",
 *         BuildTimeout = 5,
 *         QueuedTimeout = 5,
 *         ServiceRole = exampleRole.Arn,
 *         Artifacts = new Aws.CodeBuild.Inputs.ProjectArtifactsArgs
 *         {
 *             Type = "NO_ARTIFACTS",
 *         },
 *         Cache = new Aws.CodeBuild.Inputs.ProjectCacheArgs
 *         {
 *             Type = "LOCAL",
 *             Modes = new[]
 *             {
 *                 "LOCAL_DOCKER_LAYER_CACHE",
 *                 "LOCAL_SOURCE_CACHE",
 *             },
 *         },
 *         Environment = new Aws.CodeBuild.Inputs.ProjectEnvironmentArgs
 *         {
 *             ComputeType = "BUILD_GENERAL1_SMALL",
 *             Image = "aws/codebuild/amazonlinux2-x86_64-standard:4.0",
 *             Type = "LINUX_CONTAINER",
 *             ImagePullCredentialsType = "CODEBUILD",
 *             EnvironmentVariables = new[]
 *             {
 *                 new Aws.CodeBuild.Inputs.ProjectEnvironmentEnvironmentVariableArgs
 *                 {
 *                     Name = "SOME_KEY1",
 *                     Value = "SOME_VALUE1",
 *                 },
 *             },
 *         },
 *         Source = new Aws.CodeBuild.Inputs.ProjectSourceArgs
 *         {
 *             Type = "GITHUB",
 *             Location = "https://github.com/mitchellh/packer.git",
 *             GitCloneDepth = 1,
 *         },
 *         Tags =
 *         {
 *             { "Environment", "Test" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codebuild"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * Bucket: pulumi.String("example"),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = s3.NewBucketAclV2(ctx, "example", &s3.BucketAclV2Args{
 * Bucket: exampleBucketV2.ID(),
 * Acl: pulumi.String("private"),
 * })
 * if err != nil {
 * return err
 * }
 * assumeRole, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: pulumi.StringRef("Allow"),
 * Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * {
 * Type: "Service",
 * Identifiers: []string{
 * "codebuild.amazonaws.com",
 * },
 * },
 * },
 * Actions: []string{
 * "sts:AssumeRole",
 * },
 * },
 * },
 * }, nil);
 * if err != nil {
 * return err
 * }
 * exampleRole, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * Name: pulumi.String("example"),
 * AssumeRolePolicy: pulumi.String(assumeRole.Json),
 * })
 * if err != nil {
 * return err
 * }
 * example := pulumi.All(exampleBucketV2.Arn,exampleBucketV2.Arn).ApplyT(func(_args []interface{}) (iam.GetPolicyDocumentResult, error) {
 * exampleBucketV2Arn := _args[0].(string)
 * exampleBucketV2Arn1 := _args[1].(string)
 * return iam.GetPolicyDocumentResult(interface{}(iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * Statements: []iam.GetPolicyDocumentStatement{
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "logs:CreateLogGroup",
 * "logs:CreateLogStream",
 * "logs:PutLogEvents",
 * },
 * Resources: []string{
 * "*",
 * },
 * },
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "ec2:CreateNetworkInterface",
 * "ec2:DescribeDhcpOptions",
 * "ec2:DescribeNetworkInterfaces",
 * "ec2:DeleteNetworkInterface",
 * "ec2:DescribeSubnets",
 * "ec2:DescribeSecurityGroups",
 * "ec2:DescribeVpcs",
 * },
 * Resources: []string{
 * "*",
 * },
 * },
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "ec2:CreateNetworkInterfacePermission",
 * },
 * Resources: []string{
 * "arn:aws:ec2:us-east-1:123456789012:network-interface/*",
 * },
 * Conditions: []iam.GetPolicyDocumentStatementCondition{
 * {
 * Test: "StringEquals",
 * Variable: "ec2:Subnet",
 * Values: interface{}{
 * example1.Arn,
 * example2.Arn,
 * },
 * },
 * {
 * Test: "StringEquals",
 * Variable: "ec2:AuthorizedService",
 * Values: []string{
 * "codebuild.amazonaws.com",
 * },
 * },
 * },
 * },
 * {
 * Effect: "Allow",
 * Actions: []string{
 * "s3:*",
 * },
 * Resources: []string{
 * exampleBucketV2Arn,
 * fmt.Sprintf("%v/*", exampleBucketV2Arn1),
 * },
 * },
 * },
 * }, nil))), nil
 * }).(iam.GetPolicyDocumentResultOutput)
 * _, err = iam.NewRolePolicy(ctx, "example", &iam.RolePolicyArgs{
 * Role: exampleRole.Name,
 * Policy: pulumi.String(example.ApplyT(func(example iam.GetPolicyDocumentResult) (*string, error) {
 * return &example.Json, nil
 * }).(pulumi.StringPtrOutput)),
 * })
 * if err != nil {
 * return err
 * }
 * _, err = codebuild.NewProject(ctx, "example", &codebuild.ProjectArgs{
 * Name: pulumi.String("test-project"),
 * Description: pulumi.String("test_codebuild_project"),
 * BuildTimeout: pulumi.Int(5),
 * ServiceRole: exampleRole.Arn,
 * Artifacts: &codebuild.ProjectArtifactsArgs{
 * Type: pulumi.String("NO_ARTIFACTS"),
 * },
 * Cache: &codebuild.ProjectCacheArgs{
 * Type: pulumi.String("S3"),
 * Location: exampleBucketV2.Bucket,
 * },
 * Environment: &codebuild.ProjectEnvironmentArgs{
 * ComputeType: pulumi.String("BUILD_GENERAL1_SMALL"),
 * Image: pulumi.String("aws/codebuild/amazonlinux2-x86_64-standard:4.0"),
 * Type: pulumi.String("LINUX_CONTAINER"),
 * ImagePullCredentialsType: pulumi.String("CODEBUILD"),
 * EnvironmentVariables: codebuild.ProjectEnvironmentEnvironmentVariableArray{
 * &codebuild.ProjectEnvironmentEnvironmentVariableArgs{
 * Name: pulumi.String("SOME_KEY1"),
 * Value: pulumi.String("SOME_VALUE1"),
 * },
 * &codebuild.ProjectEnvironmentEnvironmentVariableArgs{
 * Name: pulumi.String("SOME_KEY2"),
 * Value: pulumi.String("SOME_VALUE2"),
 * Type: pulumi.String("PARAMETER_STORE"),
 * },
 * },
 * },
 * LogsConfig: &codebuild.ProjectLogsConfigArgs{
 * CloudwatchLogs: &codebuild.ProjectLogsConfigCloudwatchLogsArgs{
 * GroupName: pulumi.String("log-group"),
 * StreamName: pulumi.String("log-stream"),
 * },
 * S3Logs: &codebuild.ProjectLogsConfigS3LogsArgs{
 * Status: pulumi.String("ENABLED"),
 * Location: exampleBucketV2.ID().ApplyT(func(id string) (string, error) {
 * return fmt.Sprintf("%v/build-log", id), nil
 * }).(pulumi.StringOutput),
 * },
 * },
 * Source: &codebuild.ProjectSourceArgs{
 * Type: pulumi.String("GITHUB"),
 * Location: pulumi.String("https://github.com/mitchellh/packer.git"),
 * GitCloneDepth: pulumi.Int(1),
 * GitSubmodulesConfig: &codebuild.ProjectSourceGitSubmodulesConfigArgs{
 * FetchSubmodules: pulumi.Bool(true),
 * },
 * },
 * SourceVersion: pulumi.String("master"),
 * VpcConfig: &codebuild.ProjectVpcConfigArgs{
 * VpcId: pulumi.Any(exampleAwsVpc.Id),
 * Subnets: pulumi.StringArray{
 * example1.Id,
 * example2.Id,
 * },
 * SecurityGroupIds: pulumi.StringArray{
 * example1AwsSecurityGroup.Id,
 * example2AwsSecurityGroup.Id,
 * },
 * },
 * Tags: pulumi.StringMap{
 * "Environment": pulumi.String("Test"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * _, err = codebuild.NewProject(ctx, "project-with-cache", &codebuild.ProjectArgs{
 * Name: pulumi.String("test-project-cache"),
 * Description: pulumi.String("test_codebuild_project_cache"),
 * BuildTimeout: pulumi.Int(5),
 * QueuedTimeout: pulumi.Int(5),
 * ServiceRole: exampleRole.Arn,
 * Artifacts: &codebuild.ProjectArtifactsArgs{
 * Type: pulumi.String("NO_ARTIFACTS"),
 * },
 * Cache: &codebuild.ProjectCacheArgs{
 * Type: pulumi.String("LOCAL"),
 * Modes: pulumi.StringArray{
 * pulumi.String("LOCAL_DOCKER_LAYER_CACHE"),
 * pulumi.String("LOCAL_SOURCE_CACHE"),
 * },
 * },
 * Environment: &codebuild.ProjectEnvironmentArgs{
 * ComputeType: pulumi.String("BUILD_GENERAL1_SMALL"),
 * Image: pulumi.String("aws/codebuild/amazonlinux2-x86_64-standard:4.0"),
 * Type: pulumi.String("LINUX_CONTAINER"),
 * ImagePullCredentialsType: pulumi.String("CODEBUILD"),
 * EnvironmentVariables: codebuild.ProjectEnvironmentEnvironmentVariableArray{
 * &codebuild.ProjectEnvironmentEnvironmentVariableArgs{
 * Name: pulumi.String("SOME_KEY1"),
 * Value: pulumi.String("SOME_VALUE1"),
 * },
 * },
 * },
 * Source: &codebuild.ProjectSourceArgs{
 * Type: pulumi.String("GITHUB"),
 * Location: pulumi.String("https://github.com/mitchellh/packer.git"),
 * GitCloneDepth: pulumi.Int(1),
 * },
 * Tags: pulumi.StringMap{
 * "Environment": pulumi.String("Test"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicy;
 * import com.pulumi.aws.iam.RolePolicyArgs;
 * import com.pulumi.aws.codebuild.Project;
 * import com.pulumi.aws.codebuild.ProjectArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectArtifactsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectCacheArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigCloudwatchLogsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigS3LogsArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectSourceArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectSourceGitSubmodulesConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ProjectVpcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("example")
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(exampleBucketV2.id())
 *             .acl("private")
 *             .build());
 *         final var assumeRole = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("Service")
 *                     .identifiers("codebuild.amazonaws.com")
 *                     .build())
 *                 .actions("sts:AssumeRole")
 *                 .build())
 *             .build());
 *         var exampleRole = new Role("exampleRole", RoleArgs.builder()
 *             .name("example")
 *             .assumeRolePolicy(assumeRole.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "logs:CreateLogGroup",
 *                         "logs:CreateLogStream",
 *                         "logs:PutLogEvents")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions(
 *                         "ec2:CreateNetworkInterface",
 *                         "ec2:DescribeDhcpOptions",
 *                         "ec2:DescribeNetworkInterfaces",
 *                         "ec2:DeleteNetworkInterface",
 *                         "ec2:DescribeSubnets",
 *                         "ec2:DescribeSecurityGroups",
 *                         "ec2:DescribeVpcs")
 *                     .resources("*")
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("ec2:CreateNetworkInterfacePermission")
 *                     .resources("arn:aws:ec2:us-east-1:123456789012:network-interface/*")
 *                     .conditions(
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("ec2:Subnet")
 *                             .values(
 *                                 example1.arn(),
 *                                 example2.arn())
 *                             .build(),
 *                         GetPolicyDocumentStatementConditionArgs.builder()
 *                             .test("StringEquals")
 *                             .variable("ec2:AuthorizedService")
 *                             .values("codebuild.amazonaws.com")
 *                             .build())
 *                     .build(),
 *                 GetPolicyDocumentStatementArgs.builder()
 *                     .effect("Allow")
 *                     .actions("s3:*")
 *                     .resources(
 *                         exampleBucketV2.arn(),
 *                         exampleBucketV2.arn().applyValue(arn -> String.format("%s/*", arn)))
 *                     .build())
 *             .build());
 *         var exampleRolePolicy = new RolePolicy("exampleRolePolicy", RolePolicyArgs.builder()
 *             .role(exampleRole.name())
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(example -> example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *         var exampleProject = new Project("exampleProject", ProjectArgs.builder()
 *             .name("test-project")
 *             .description("test_codebuild_project")
 *             .buildTimeout(5)
 *             .serviceRole(exampleRole.arn())
 *             .artifacts(ProjectArtifactsArgs.builder()
 *                 .type("NO_ARTIFACTS")
 *                 .build())
 *             .cache(ProjectCacheArgs.builder()
 *                 .type("S3")
 *                 .location(exampleBucketV2.bucket())
 *                 .build())
 *             .environment(ProjectEnvironmentArgs.builder()
 *                 .computeType("BUILD_GENERAL1_SMALL")
 *                 .image("aws/codebuild/amazonlinux2-x86_64-standard:4.0")
 *                 .type("LINUX_CONTAINER")
 *                 .imagePullCredentialsType("CODEBUILD")
 *                 .environmentVariables(
 *                     ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                         .name("SOME_KEY1")
 *                         .value("SOME_VALUE1")
 *                         .build(),
 *                     ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                         .name("SOME_KEY2")
 *                         .value("SOME_VALUE2")
 *                         .type("PARAMETER_STORE")
 *                         .build())
 *                 .build())
 *             .logsConfig(ProjectLogsConfigArgs.builder()
 *                 .cloudwatchLogs(ProjectLogsConfigCloudwatchLogsArgs.builder()
 *                     .groupName("log-group")
 *                     .streamName("log-stream")
 *                     .build())
 *                 .s3Logs(ProjectLogsConfigS3LogsArgs.builder()
 *                     .status("ENABLED")
 *                     .location(exampleBucketV2.id().applyValue(id -> String.format("%s/build-log", id)))
 *                     .build())
 *                 .build())
 *             .source(ProjectSourceArgs.builder()
 *                 .type("GITHUB")
 *                 .location("https://github.com/mitchellh/packer.git")
 *                 .gitCloneDepth(1)
 *                 .gitSubmodulesConfig(ProjectSourceGitSubmodulesConfigArgs.builder()
 *                     .fetchSubmodules(true)
 *                     .build())
 *                 .build())
 *             .sourceVersion("master")
 *             .vpcConfig(ProjectVpcConfigArgs.builder()
 *                 .vpcId(exampleAwsVpc.id())
 *                 .subnets(
 *                     example1.id(),
 *                     example2.id())
 *                 .securityGroupIds(
 *                     example1AwsSecurityGroup.id(),
 *                     example2AwsSecurityGroup.id())
 *                 .build())
 *             .tags(Map.of("Environment", "Test"))
 *             .build());
 *         var project_with_cache = new Project("project-with-cache", ProjectArgs.builder()
 *             .name("test-project-cache")
 *             .description("test_codebuild_project_cache")
 *             .buildTimeout(5)
 *             .queuedTimeout(5)
 *             .serviceRole(exampleRole.arn())
 *             .artifacts(ProjectArtifactsArgs.builder()
 *                 .type("NO_ARTIFACTS")
 *                 .build())
 *             .cache(ProjectCacheArgs.builder()
 *                 .type("LOCAL")
 *                 .modes(
 *                     "LOCAL_DOCKER_LAYER_CACHE",
 *                     "LOCAL_SOURCE_CACHE")
 *                 .build())
 *             .environment(ProjectEnvironmentArgs.builder()
 *                 .computeType("BUILD_GENERAL1_SMALL")
 *                 .image("aws/codebuild/amazonlinux2-x86_64-standard:4.0")
 *                 .type("LINUX_CONTAINER")
 *                 .imagePullCredentialsType("CODEBUILD")
 *                 .environmentVariables(ProjectEnvironmentEnvironmentVariableArgs.builder()
 *                     .name("SOME_KEY1")
 *                     .value("SOME_VALUE1")
 *                     .build())
 *                 .build())
 *             .source(ProjectSourceArgs.builder()
 *                 .type("GITHUB")
 *                 .location("https://github.com/mitchellh/packer.git")
 *                 .gitCloneDepth(1)
 *                 .build())
 *             .tags(Map.of("Environment", "Test"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: example
 *   exampleBucketAclV2:
 *     type: aws:s3:BucketAclV2
 *     name: example
 *     properties:
 *       bucket: ${exampleBucketV2.id}
 *       acl: private
 *   exampleRole:
 *     type: aws:iam:Role
 *     name: example
 *     properties:
 *       name: example
 *       assumeRolePolicy: ${assumeRole.json}
 *   exampleRolePolicy:
 *     type: aws:iam:RolePolicy
 *     name: example
 *     properties:
 *       role: ${exampleRole.name}
 *       policy: ${example.json}
 *   exampleProject:
 *     type: aws:codebuild:Project
 *     name: example
 *     properties:
 *       name: test-project
 *       description: test_codebuild_project
 *       buildTimeout: 5
 *       serviceRole: ${exampleRole.arn}
 *       artifacts:
 *         type: NO_ARTIFACTS
 *       cache:
 *         type: S3
 *         location: ${exampleBucketV2.bucket}
 *       environment:
 *         computeType: BUILD_GENERAL1_SMALL
 *         image: aws/codebuild/amazonlinux2-x86_64-standard:4.0
 *         type: LINUX_CONTAINER
 *         imagePullCredentialsType: CODEBUILD
 *         environmentVariables:
 *           - name: SOME_KEY1
 *             value: SOME_VALUE1
 *           - name: SOME_KEY2
 *             value: SOME_VALUE2
 *             type: PARAMETER_STORE
 *       logsConfig:
 *         cloudwatchLogs:
 *           groupName: log-group
 *           streamName: log-stream
 *         s3Logs:
 *           status: ENABLED
 *           location: ${exampleBucketV2.id}/build-log
 *       source:
 *         type: GITHUB
 *         location: https://github.com/mitchellh/packer.git
 *         gitCloneDepth: 1
 *         gitSubmodulesConfig:
 *           fetchSubmodules: true
 *       sourceVersion: master
 *       vpcConfig:
 *         vpcId: ${exampleAwsVpc.id}
 *         subnets:
 *           - ${example1.id}
 *           - ${example2.id}
 *         securityGroupIds:
 *           - ${example1AwsSecurityGroup.id}
 *           - ${example2AwsSecurityGroup.id}
 *       tags:
 *         Environment: Test
 *   project-with-cache:
 *     type: aws:codebuild:Project
 *     properties:
 *       name: test-project-cache
 *       description: test_codebuild_project_cache
 *       buildTimeout: 5
 *       queuedTimeout: 5
 *       serviceRole: ${exampleRole.arn}
 *       artifacts:
 *         type: NO_ARTIFACTS
 *       cache:
 *         type: LOCAL
 *         modes:
 *           - LOCAL_DOCKER_LAYER_CACHE
 *           - LOCAL_SOURCE_CACHE
 *       environment:
 *         computeType: BUILD_GENERAL1_SMALL
 *         image: aws/codebuild/amazonlinux2-x86_64-standard:4.0
 *         type: LINUX_CONTAINER
 *         imagePullCredentialsType: CODEBUILD
 *         environmentVariables:
 *           - name: SOME_KEY1
 *             value: SOME_VALUE1
 *       source:
 *         type: GITHUB
 *         location: https://github.com/mitchellh/packer.git
 *         gitCloneDepth: 1
 *       tags:
 *         Environment: Test
 * variables:
 *   assumeRole:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             principals:
 *               - type: Service
 *                 identifiers:
 *                   - codebuild.amazonaws.com
 *             actions:
 *               - sts:AssumeRole
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - effect: Allow
 *             actions:
 *               - logs:CreateLogGroup
 *               - logs:CreateLogStream
 *               - logs:PutLogEvents
 *             resources:
 *               - '*'
 *           - effect: Allow
 *             actions:
 *               - ec2:CreateNetworkInterface
 *               - ec2:DescribeDhcpOptions
 *               - ec2:DescribeNetworkInterfaces
 *               - ec2:DeleteNetworkInterface
 *               - ec2:DescribeSubnets
 *               - ec2:DescribeSecurityGroups
 *               - ec2:DescribeVpcs
 *             resources:
 *               - '*'
 *           - effect: Allow
 *             actions:
 *               - ec2:CreateNetworkInterfacePermission
 *             resources:
 *               - arn:aws:ec2:us-east-1:123456789012:network-interface/*
 *             conditions:
 *               - test: StringEquals
 *                 variable: ec2:Subnet
 *                 values:
 *                   - ${example1.arn}
 *                   - ${example2.arn}
 *               - test: StringEquals
 *                 variable: ec2:AuthorizedService
 *                 values:
 *                   - codebuild.amazonaws.com
 *           - effect: Allow
 *             actions:
 *               - s3:*
 *             resources:
 *               - ${exampleBucketV2.arn}
 *               - ${exampleBucketV2.arn}/*
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeBuild Project using the `name`. For example:
 * ```sh
 * $ pulumi import aws:codebuild/project:Project name project-name
 * ```
 * @property artifacts Configuration block. Detailed below.
 * @property badgeEnabled Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
 * @property buildBatchConfig Defines the batch build options for the project.
 * @property buildTimeout Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is not available on the `Lambda` compute type.
 * @property cache Configuration block. Detailed below.
 * @property concurrentBuildLimit Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
 * @property description Short description of the project.
 * @property encryptionKey AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
 * @property environment Configuration block. Detailed below.
 * @property fileSystemLocations A set of file system locations to mount inside the build. File system locations are documented below.
 * @property logsConfig Configuration block. Detailed below.
 * @property name Project's name.
 * @property projectVisibility Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
 * @property queuedTimeout Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
 * @property resourceAccessRole The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if `project_visibility` is `PUBLIC_READ`.
 * @property secondaryArtifacts Configuration block. Detailed below.
 * @property secondarySourceVersions Configuration block. Detailed below.
 * @property secondarySources Configuration block. Detailed below.
 * @property serviceRole Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
 * @property source Configuration block. Detailed below.
 * The following arguments are optional:
 * @property sourceVersion Version of the build input to be built for this project. If not specified, the latest version is used.
 * @property tags Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcConfig Configuration block. Detailed below.
 * */*/*/*/*/*/*/*/*/*/*/*/
 */
public data class ProjectArgs(
    public val artifacts: Output<ProjectArtifactsArgs>? = null,
    public val badgeEnabled: Output<Boolean>? = null,
    public val buildBatchConfig: Output<ProjectBuildBatchConfigArgs>? = null,
    public val buildTimeout: Output<Int>? = null,
    public val cache: Output<ProjectCacheArgs>? = null,
    public val concurrentBuildLimit: Output<Int>? = null,
    public val description: Output<String>? = null,
    public val encryptionKey: Output<String>? = null,
    public val environment: Output<ProjectEnvironmentArgs>? = null,
    public val fileSystemLocations: Output<List<ProjectFileSystemLocationArgs>>? = null,
    public val logsConfig: Output<ProjectLogsConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val projectVisibility: Output<String>? = null,
    public val queuedTimeout: Output<Int>? = null,
    public val resourceAccessRole: Output<String>? = null,
    public val secondaryArtifacts: Output<List<ProjectSecondaryArtifactArgs>>? = null,
    public val secondarySourceVersions: Output<List<ProjectSecondarySourceVersionArgs>>? = null,
    public val secondarySources: Output<List<ProjectSecondarySourceArgs>>? = null,
    public val serviceRole: Output<String>? = null,
    public val source: Output<ProjectSourceArgs>? = null,
    public val sourceVersion: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfig: Output<ProjectVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.ProjectArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.ProjectArgs =
        com.pulumi.aws.codebuild.ProjectArgs.builder()
            .artifacts(artifacts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .badgeEnabled(badgeEnabled?.applyValue({ args0 -> args0 }))
            .buildBatchConfig(buildBatchConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .buildTimeout(buildTimeout?.applyValue({ args0 -> args0 }))
            .cache(cache?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .concurrentBuildLimit(concurrentBuildLimit?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptionKey(encryptionKey?.applyValue({ args0 -> args0 }))
            .environment(environment?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fileSystemLocations(
                fileSystemLocations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .logsConfig(logsConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .projectVisibility(projectVisibility?.applyValue({ args0 -> args0 }))
            .queuedTimeout(queuedTimeout?.applyValue({ args0 -> args0 }))
            .resourceAccessRole(resourceAccessRole?.applyValue({ args0 -> args0 }))
            .secondaryArtifacts(
                secondaryArtifacts?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .secondarySourceVersions(
                secondarySourceVersions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .secondarySources(
                secondarySources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceRole(serviceRole?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceVersion(sourceVersion?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ProjectArgs].
 */
@PulumiTagMarker
public class ProjectArgsBuilder internal constructor() {
    private var artifacts: Output<ProjectArtifactsArgs>? = null

    private var badgeEnabled: Output<Boolean>? = null

    private var buildBatchConfig: Output<ProjectBuildBatchConfigArgs>? = null

    private var buildTimeout: Output<Int>? = null

    private var cache: Output<ProjectCacheArgs>? = null

    private var concurrentBuildLimit: Output<Int>? = null

    private var description: Output<String>? = null

    private var encryptionKey: Output<String>? = null

    private var environment: Output<ProjectEnvironmentArgs>? = null

    private var fileSystemLocations: Output<List<ProjectFileSystemLocationArgs>>? = null

    private var logsConfig: Output<ProjectLogsConfigArgs>? = null

    private var name: Output<String>? = null

    private var projectVisibility: Output<String>? = null

    private var queuedTimeout: Output<Int>? = null

    private var resourceAccessRole: Output<String>? = null

    private var secondaryArtifacts: Output<List<ProjectSecondaryArtifactArgs>>? = null

    private var secondarySourceVersions: Output<List<ProjectSecondarySourceVersionArgs>>? = null

    private var secondarySources: Output<List<ProjectSecondarySourceArgs>>? = null

    private var serviceRole: Output<String>? = null

    private var source: Output<ProjectSourceArgs>? = null

    private var sourceVersion: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfig: Output<ProjectVpcConfigArgs>? = null

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("kvkwtonxetiofpoi")
    public suspend fun artifacts(`value`: Output<ProjectArtifactsArgs>) {
        this.artifacts = value
    }

    /**
     * @param value Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
     */
    @JvmName("qupsxjlfsfcicwry")
    public suspend fun badgeEnabled(`value`: Output<Boolean>) {
        this.badgeEnabled = value
    }

    /**
     * @param value Defines the batch build options for the project.
     */
    @JvmName("inppjjbakgvwaqay")
    public suspend fun buildBatchConfig(`value`: Output<ProjectBuildBatchConfigArgs>) {
        this.buildBatchConfig = value
    }

    /**
     * @param value Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is not available on the `Lambda` compute type.
     */
    @JvmName("jabkboaihguhlboa")
    public suspend fun buildTimeout(`value`: Output<Int>) {
        this.buildTimeout = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("evtkyhgneuvwtqjh")
    public suspend fun cache(`value`: Output<ProjectCacheArgs>) {
        this.cache = value
    }

    /**
     * @param value Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
     */
    @JvmName("sgakhmrgqjqhblxv")
    public suspend fun concurrentBuildLimit(`value`: Output<Int>) {
        this.concurrentBuildLimit = value
    }

    /**
     * @param value Short description of the project.
     */
    @JvmName("gbujsqfjaswmqpau")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
     */
    @JvmName("krulrbudmpwvbsff")
    public suspend fun encryptionKey(`value`: Output<String>) {
        this.encryptionKey = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("gmfstpmrjwdmrtwn")
    public suspend fun environment(`value`: Output<ProjectEnvironmentArgs>) {
        this.environment = value
    }

    /**
     * @param value A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("tvokfsqwleqkymol")
    public suspend fun fileSystemLocations(`value`: Output<List<ProjectFileSystemLocationArgs>>) {
        this.fileSystemLocations = value
    }

    @JvmName("wrixdbstvfklpwre")
    public suspend fun fileSystemLocations(vararg values: Output<ProjectFileSystemLocationArgs>) {
        this.fileSystemLocations = Output.all(values.asList())
    }

    /**
     * @param values A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("oeldfbrppvnogsfy")
    public suspend fun fileSystemLocations(values: List<Output<ProjectFileSystemLocationArgs>>) {
        this.fileSystemLocations = Output.all(values)
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("pmbrtnnwcicyosla")
    public suspend fun logsConfig(`value`: Output<ProjectLogsConfigArgs>) {
        this.logsConfig = value
    }

    /**
     * @param value Project's name.
     */
    @JvmName("eoevslhgeirrpdcg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
     */
    @JvmName("jywewkvgbhnvrsja")
    public suspend fun projectVisibility(`value`: Output<String>) {
        this.projectVisibility = value
    }

    /**
     * @param value Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
     */
    @JvmName("lneecjfqqbwwnpiy")
    public suspend fun queuedTimeout(`value`: Output<Int>) {
        this.queuedTimeout = value
    }

    /**
     * @param value The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if `project_visibility` is `PUBLIC_READ`.
     */
    @JvmName("tidrpmonsrryptks")
    public suspend fun resourceAccessRole(`value`: Output<String>) {
        this.resourceAccessRole = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("bjvifijvowyhkljc")
    public suspend fun secondaryArtifacts(`value`: Output<List<ProjectSecondaryArtifactArgs>>) {
        this.secondaryArtifacts = value
    }

    @JvmName("qkfjhdugnbivsxlt")
    public suspend fun secondaryArtifacts(vararg values: Output<ProjectSecondaryArtifactArgs>) {
        this.secondaryArtifacts = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("pugmtqupopjgoxsk")
    public suspend fun secondaryArtifacts(values: List<Output<ProjectSecondaryArtifactArgs>>) {
        this.secondaryArtifacts = Output.all(values)
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("mkeixumtqmqwomto")
    public suspend fun secondarySourceVersions(`value`: Output<List<ProjectSecondarySourceVersionArgs>>) {
        this.secondarySourceVersions = value
    }

    @JvmName("mpbakhbgwmbvhdlh")
    public suspend fun secondarySourceVersions(vararg values: Output<ProjectSecondarySourceVersionArgs>) {
        this.secondarySourceVersions = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("wfxrvlneqikxukqi")
    public suspend fun secondarySourceVersions(values: List<Output<ProjectSecondarySourceVersionArgs>>) {
        this.secondarySourceVersions = Output.all(values)
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("hivrvqoljysyhvtp")
    public suspend fun secondarySources(`value`: Output<List<ProjectSecondarySourceArgs>>) {
        this.secondarySources = value
    }

    @JvmName("camcrlymhgplrilg")
    public suspend fun secondarySources(vararg values: Output<ProjectSecondarySourceArgs>) {
        this.secondarySources = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("rkjchslymnpwslde")
    public suspend fun secondarySources(values: List<Output<ProjectSecondarySourceArgs>>) {
        this.secondarySources = Output.all(values)
    }

    /**
     * @param value Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    @JvmName("lqkpgeaerfmowyeo")
    public suspend fun serviceRole(`value`: Output<String>) {
        this.serviceRole = value
    }

    /**
     * @param value Configuration block. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("vxouaollrspesuyg")
    public suspend fun source(`value`: Output<ProjectSourceArgs>) {
        this.source = value
    }

    /**
     * @param value Version of the build input to be built for this project. If not specified, the latest version is used.
     */
    @JvmName("yhbevhcbtmttpufr")
    public suspend fun sourceVersion(`value`: Output<String>) {
        this.sourceVersion = value
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("npsgnjkspkdyywlr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("jdsljqpikhxbdcnc")
    public suspend fun vpcConfig(`value`: Output<ProjectVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("jcaorieflewkqkxl")
    public suspend fun artifacts(`value`: ProjectArtifactsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("cwxwwvaupesgtarb")
    public suspend fun artifacts(argument: suspend ProjectArtifactsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectArtifactsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param value Generates a publicly-accessible URL for the projects build badge. Available as `badge_url` attribute when enabled.
     */
    @JvmName("khxqsmigjqeoxskl")
    public suspend fun badgeEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.badgeEnabled = mapped
    }

    /**
     * @param value Defines the batch build options for the project.
     */
    @JvmName("fuejoqpnbcqoodol")
    public suspend fun buildBatchConfig(`value`: ProjectBuildBatchConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildBatchConfig = mapped
    }

    /**
     * @param argument Defines the batch build options for the project.
     */
    @JvmName("nuyrikeivdgndeip")
    public suspend fun buildBatchConfig(argument: suspend ProjectBuildBatchConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectBuildBatchConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.buildBatchConfig = mapped
    }

    /**
     * @param value Number of minutes, from 5 to 2160 (36 hours), for AWS CodeBuild to wait until timing out any related build that does not get marked as completed. The default is 60 minutes. The `build_timeout` property is not available on the `Lambda` compute type.
     */
    @JvmName("wceeryljuyaefkxc")
    public suspend fun buildTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildTimeout = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("vkpkyvtuqnqcqouq")
    public suspend fun cache(`value`: ProjectCacheArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cache = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("xlfwuapypbcivxve")
    public suspend fun cache(argument: suspend ProjectCacheArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectCacheArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cache = mapped
    }

    /**
     * @param value Specify a maximum number of concurrent builds for the project. The value specified must be greater than 0 and less than the account concurrent running builds limit.
     */
    @JvmName("mtqwsghucuaxkihi")
    public suspend fun concurrentBuildLimit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.concurrentBuildLimit = mapped
    }

    /**
     * @param value Short description of the project.
     */
    @JvmName("naqdgtjthhumeqob")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value AWS Key Management Service (AWS KMS) customer master key (CMK) to be used for encrypting the build project's build output artifacts.
     */
    @JvmName("smiuegtpqylqdvnp")
    public suspend fun encryptionKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionKey = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("wyrchdpjabhsxcwa")
    public suspend fun environment(`value`: ProjectEnvironmentArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environment = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("ctmosbhqkuxgdmwt")
    public suspend fun environment(argument: suspend ProjectEnvironmentArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectEnvironmentArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.environment = mapped
    }

    /**
     * @param value A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("yjxjhagfhtbvlyme")
    public suspend fun fileSystemLocations(`value`: List<ProjectFileSystemLocationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemLocations = mapped
    }

    /**
     * @param argument A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("iecxwrjlssjqdlxo")
    public suspend fun fileSystemLocations(argument: List<suspend ProjectFileSystemLocationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectFileSystemLocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fileSystemLocations = mapped
    }

    /**
     * @param argument A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("fgvyltdbbgtwjalm")
    public suspend fun fileSystemLocations(vararg argument: suspend ProjectFileSystemLocationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProjectFileSystemLocationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.fileSystemLocations = mapped
    }

    /**
     * @param argument A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("viaoyriiyabksrnu")
    public suspend fun fileSystemLocations(argument: suspend ProjectFileSystemLocationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProjectFileSystemLocationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.fileSystemLocations = mapped
    }

    /**
     * @param values A set of file system locations to mount inside the build. File system locations are documented below.
     */
    @JvmName("cepraldgwkmdyqid")
    public suspend fun fileSystemLocations(vararg values: ProjectFileSystemLocationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fileSystemLocations = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("bwoblhjulytawxws")
    public suspend fun logsConfig(`value`: ProjectLogsConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logsConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("udjrbiyflfrqeayr")
    public suspend fun logsConfig(argument: suspend ProjectLogsConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectLogsConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logsConfig = mapped
    }

    /**
     * @param value Project's name.
     */
    @JvmName("jyydwlbkjblyeshj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the visibility of the project's builds. Possible values are: `PUBLIC_READ` and `PRIVATE`. Default value is `PRIVATE`.
     */
    @JvmName("uihvlaqiutyudnsq")
    public suspend fun projectVisibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectVisibility = mapped
    }

    /**
     * @param value Number of minutes, from 5 to 480 (8 hours), a build is allowed to be queued before it times out. The default is 8 hours. The `queued_timeout` property is not available on the `Lambda` compute type.
     */
    @JvmName("sqqqdkkdbvokqpfx")
    public suspend fun queuedTimeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queuedTimeout = mapped
    }

    /**
     * @param value The ARN of the IAM role that enables CodeBuild to access the CloudWatch Logs and Amazon S3 artifacts for the project's builds in order to display them publicly. Only applicable if `project_visibility` is `PUBLIC_READ`.
     */
    @JvmName("dlbiataweltlynid")
    public suspend fun resourceAccessRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceAccessRole = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("dthkodbquwxkpeji")
    public suspend fun secondaryArtifacts(`value`: List<ProjectSecondaryArtifactArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryArtifacts = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("mmbdsjmbkqxvlalm")
    public suspend fun secondaryArtifacts(argument: List<suspend ProjectSecondaryArtifactArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectSecondaryArtifactArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secondaryArtifacts = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("ysqkkdhrehscnumt")
    public suspend fun secondaryArtifacts(vararg argument: suspend ProjectSecondaryArtifactArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProjectSecondaryArtifactArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secondaryArtifacts = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("ldhmoakcsmffckil")
    public suspend fun secondaryArtifacts(argument: suspend ProjectSecondaryArtifactArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProjectSecondaryArtifactArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.secondaryArtifacts = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("qdnahkiibstflyik")
    public suspend fun secondaryArtifacts(vararg values: ProjectSecondaryArtifactArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryArtifacts = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("rtpadtlaejeylecf")
    public suspend fun secondarySourceVersions(`value`: List<ProjectSecondarySourceVersionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondarySourceVersions = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("errmbnnviffcfgjl")
    public suspend fun secondarySourceVersions(argument: List<suspend ProjectSecondarySourceVersionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectSecondarySourceVersionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.secondarySourceVersions = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("iyckmmoeadabwfbi")
    public suspend fun secondarySourceVersions(vararg argument: suspend ProjectSecondarySourceVersionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProjectSecondarySourceVersionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.secondarySourceVersions = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("ovlvtrrciysvgtqy")
    public suspend fun secondarySourceVersions(argument: suspend ProjectSecondarySourceVersionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProjectSecondarySourceVersionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.secondarySourceVersions = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("qaaktxpeiruibnaa")
    public suspend fun secondarySourceVersions(vararg values: ProjectSecondarySourceVersionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondarySourceVersions = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("dekibttaxxpckoph")
    public suspend fun secondarySources(`value`: List<ProjectSecondarySourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondarySources = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("nkeimgegjvnagtql")
    public suspend fun secondarySources(argument: List<suspend ProjectSecondarySourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectSecondarySourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secondarySources = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("yngmsqindrvnrgtr")
    public suspend fun secondarySources(vararg argument: suspend ProjectSecondarySourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProjectSecondarySourceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.secondarySources = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("lampybcetpxlwsox")
    public suspend fun secondarySources(argument: suspend ProjectSecondarySourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ProjectSecondarySourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.secondarySources = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("somafsuclmeskwri")
    public suspend fun secondarySources(vararg values: ProjectSecondarySourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondarySources = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that enables AWS CodeBuild to interact with dependent AWS services on behalf of the AWS account.
     */
    @JvmName("adcnmxynxlxvincy")
    public suspend fun serviceRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceRole = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("soljsneqkdtjamie")
    public suspend fun source(`value`: ProjectSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     * The following arguments are optional:
     */
    @JvmName("rnhpfjutmphhyqty")
    public suspend fun source(argument: suspend ProjectSourceArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    /**
     * @param value Version of the build input to be built for this project. If not specified, the latest version is used.
     */
    @JvmName("uifaxfldcxvmoeau")
    public suspend fun sourceVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceVersion = mapped
    }

    /**
     * @param value Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kxhjbtnsflucckxv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mkxsakkrehueygnk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("tiaweqjdyehlicnh")
    public suspend fun vpcConfig(`value`: ProjectVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("cllrsvpgbxwbuuxn")
    public suspend fun vpcConfig(argument: suspend ProjectVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): ProjectArgs = ProjectArgs(
        artifacts = artifacts,
        badgeEnabled = badgeEnabled,
        buildBatchConfig = buildBatchConfig,
        buildTimeout = buildTimeout,
        cache = cache,
        concurrentBuildLimit = concurrentBuildLimit,
        description = description,
        encryptionKey = encryptionKey,
        environment = environment,
        fileSystemLocations = fileSystemLocations,
        logsConfig = logsConfig,
        name = name,
        projectVisibility = projectVisibility,
        queuedTimeout = queuedTimeout,
        resourceAccessRole = resourceAccessRole,
        secondaryArtifacts = secondaryArtifacts,
        secondarySourceVersions = secondarySourceVersions,
        secondarySources = secondarySources,
        serviceRole = serviceRole,
        source = source,
        sourceVersion = sourceVersion,
        tags = tags,
        vpcConfig = vpcConfig,
    )
}
