@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.kotlin.outputs.ReportGroupExportConfig
import com.pulumi.aws.codebuild.kotlin.outputs.ReportGroupExportConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ReportGroup].
 */
@PulumiTagMarker
public class ReportGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ReportGroupArgs = ReportGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ReportGroupArgsBuilder.() -> Unit) {
        val builder = ReportGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ReportGroup {
        val builtJavaResource = com.pulumi.aws.codebuild.ReportGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ReportGroup(builtJavaResource)
    }
}

/**
 * Provides a CodeBuild Report Groups Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = current.then(current => aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "Enable IAM User Permissions",
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: [`arn:aws:iam::${current&#46;accountId}:root`],
 *         }],
 *         actions: ["kms:*"],
 *         resources: ["*"],
 *     }],
 * }));
 * const exampleKey = new aws.kms.Key("example", {
 *     description: "my test kms key",
 *     deletionWindowInDays: 7,
 *     policy: example.then(example => example.json),
 * });
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "my-test"});
 * const exampleReportGroup = new aws.codebuild.ReportGroup("example", {
 *     name: "my test report group",
 *     type: "TEST",
 *     exportConfig: {
 *         type: "S3",
 *         s3Destination: {
 *             bucket: exampleBucketV2.id,
 *             encryptionDisabled: false,
 *             encryptionKey: exampleKey.arn,
 *             packaging: "NONE",
 *             path: "/some",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.iam.get_policy_document(statements=[{
 *     "sid": "Enable IAM User Permissions",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": [f"arn:aws:iam::{current&#46;account_id}:root"],
 *     }],
 *     "actions": ["kms:*"],
 *     "resources": ["*"],
 * }])
 * example_key = aws.kms.Key("example",
 *     description="my test kms key",
 *     deletion_window_in_days=7,
 *     policy=example.json)
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket="my-test")
 * example_report_group = aws.codebuild.ReportGroup("example",
 *     name="my test report group",
 *     type="TEST",
 *     export_config={
 *         "type": "S3",
 *         "s3_destination": {
 *             "bucket": example_bucket_v2.id,
 *             "encryption_disabled": False,
 *             "encryption_key": example_key.arn,
 *             "packaging": "NONE",
 *             "path": "/some",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "Enable IAM User Permissions",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             $"arn:aws:iam::{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:root",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "kms:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleKey = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "my test kms key",
 *         DeletionWindowInDays = 7,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "my-test",
 *     });
 *     var exampleReportGroup = new Aws.CodeBuild.ReportGroup("example", new()
 *     {
 *         Name = "my test report group",
 *         Type = "TEST",
 *         ExportConfig = new Aws.CodeBuild.Inputs.ReportGroupExportConfigArgs
 *         {
 *             Type = "S3",
 *             S3Destination = new Aws.CodeBuild.Inputs.ReportGroupExportConfigS3DestinationArgs
 *             {
 *                 Bucket = exampleBucketV2.Id,
 *                 EncryptionDisabled = false,
 *                 EncryptionKey = exampleKey.Arn,
 *                 Packaging = "NONE",
 *                 Path = "/some",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codebuild"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("Enable IAM User Permissions"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								fmt.Sprintf("arn:aws:iam::%v:root", current.AccountId),
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"kms:*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("my test kms key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 			Policy:               pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codebuild.NewReportGroup(ctx, "example", &codebuild.ReportGroupArgs{
 * 			Name: pulumi.String("my test report group"),
 * 			Type: pulumi.String("TEST"),
 * 			ExportConfig: &codebuild.ReportGroupExportConfigArgs{
 * 				Type: pulumi.String("S3"),
 * 				S3Destination: &codebuild.ReportGroupExportConfigS3DestinationArgs{
 * 					Bucket:             exampleBucketV2.ID(),
 * 					EncryptionDisabled: pulumi.Bool(false),
 * 					EncryptionKey:      exampleKey.Arn,
 * 					Packaging:          pulumi.String("NONE"),
 * 					Path:               pulumi.String("/some"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.codebuild.ReportGroup;
 * import com.pulumi.aws.codebuild.ReportGroupArgs;
 * import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigS3DestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("Enable IAM User Permissions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("kms:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("my test kms key")
 *             .deletionWindowInDays(7)
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("my-test")
 *             .build());
 *         var exampleReportGroup = new ReportGroup("exampleReportGroup", ReportGroupArgs.builder()
 *             .name("my test report group")
 *             .type("TEST")
 *             .exportConfig(ReportGroupExportConfigArgs.builder()
 *                 .type("S3")
 *                 .s3Destination(ReportGroupExportConfigS3DestinationArgs.builder()
 *                     .bucket(exampleBucketV2.id())
 *                     .encryptionDisabled(false)
 *                     .encryptionKey(exampleKey.arn())
 *                     .packaging("NONE")
 *                     .path("/some")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleKey:
 *     type: aws:kms:Key
 *     name: example
 *     properties:
 *       description: my test kms key
 *       deletionWindowInDays: 7
 *       policy: ${example.json}
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: my-test
 *   exampleReportGroup:
 *     type: aws:codebuild:ReportGroup
 *     name: example
 *     properties:
 *       name: my test report group
 *       type: TEST
 *       exportConfig:
 *         type: S3
 *         s3Destination:
 *           bucket: ${exampleBucketV2.id}
 *           encryptionDisabled: false
 *           encryptionKey: ${exampleKey.arn}
 *           packaging: NONE
 *           path: /some
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: Enable IAM User Permissions
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - arn:aws:iam::${current.accountId}:root
 *             actions:
 *               - kms:*
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeBuild Report Group using the CodeBuild Report Group arn. For example:
 * ```sh
 * $ pulumi import aws:codebuild/reportGroup:ReportGroup example arn:aws:codebuild:us-west-2:123456789:report-group/report-group-name
 * ```
 */
public class ReportGroup internal constructor(
    override val javaResource: com.pulumi.aws.codebuild.ReportGroup,
) : KotlinCustomResource(javaResource, ReportGroupMapper) {
    /**
     * The ARN of Report Group.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The date and time this Report Group was created.
     */
    public val created: Output<String>
        get() = javaResource.created().applyValue({ args0 -> args0 })

    /**
     * If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
     */
    public val deleteReports: Output<Boolean>?
        get() = javaResource.deleteReports().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
     */
    public val exportConfig: Output<ReportGroupExportConfig>
        get() = javaResource.exportConfig().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The name of a Report Group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ReportGroupMapper : ResourceMapper<ReportGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codebuild.ReportGroup::class == javaResource::class

    override fun map(javaResource: Resource): ReportGroup = ReportGroup(
        javaResource as
            com.pulumi.aws.codebuild.ReportGroup,
    )
}

/**
 * @see [ReportGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ReportGroup].
 */
public suspend fun reportGroup(name: String, block: suspend ReportGroupResourceBuilder.() -> Unit): ReportGroup {
    val builder = ReportGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ReportGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun reportGroup(name: String): ReportGroup {
    val builder = ReportGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
