@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.ReportGroupArgs.builder
import com.pulumi.aws.codebuild.kotlin.inputs.ReportGroupExportConfigArgs
import com.pulumi.aws.codebuild.kotlin.inputs.ReportGroupExportConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a CodeBuild Report Groups Resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const current = aws.getCallerIdentity({});
 * const example = current.then(current => aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "Enable IAM User Permissions",
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: [`arn:aws:iam::${current&#46;accountId}:root`],
 *         }],
 *         actions: ["kms:*"],
 *         resources: ["*"],
 *     }],
 * }));
 * const exampleKey = new aws.kms.Key("example", {
 *     description: "my test kms key",
 *     deletionWindowInDays: 7,
 *     policy: example.then(example => example.json),
 * });
 * const exampleBucketV2 = new aws.s3.BucketV2("example", {bucket: "my-test"});
 * const exampleReportGroup = new aws.codebuild.ReportGroup("example", {
 *     name: "my test report group",
 *     type: "TEST",
 *     exportConfig: {
 *         type: "S3",
 *         s3Destination: {
 *             bucket: exampleBucketV2.id,
 *             encryptionDisabled: false,
 *             encryptionKey: exampleKey.arn,
 *             packaging: "NONE",
 *             path: "/some",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * current = aws.get_caller_identity()
 * example = aws.iam.get_policy_document(statements=[{
 *     "sid": "Enable IAM User Permissions",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": [f"arn:aws:iam::{current&#46;account_id}:root"],
 *     }],
 *     "actions": ["kms:*"],
 *     "resources": ["*"],
 * }])
 * example_key = aws.kms.Key("example",
 *     description="my test kms key",
 *     deletion_window_in_days=7,
 *     policy=example.json)
 * example_bucket_v2 = aws.s3.BucketV2("example", bucket="my-test")
 * example_report_group = aws.codebuild.ReportGroup("example",
 *     name="my test report group",
 *     type="TEST",
 *     export_config={
 *         "type": "S3",
 *         "s3_destination": {
 *             "bucket": example_bucket_v2.id,
 *             "encryption_disabled": False,
 *             "encryption_key": example_key.arn,
 *             "packaging": "NONE",
 *             "path": "/some",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var current = Aws.GetCallerIdentity.Invoke();
 *     var example = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "Enable IAM User Permissions",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             $"arn:aws:iam::{current.Apply(getCallerIdentityResult => getCallerIdentityResult.AccountId)}:root",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "kms:*",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "*",
 *                 },
 *             },
 *         },
 *     });
 *     var exampleKey = new Aws.Kms.Key("example", new()
 *     {
 *         Description = "my test kms key",
 *         DeletionWindowInDays = 7,
 *         Policy = example.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 *     var exampleBucketV2 = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "my-test",
 *     });
 *     var exampleReportGroup = new Aws.CodeBuild.ReportGroup("example", new()
 *     {
 *         Name = "my test report group",
 *         Type = "TEST",
 *         ExportConfig = new Aws.CodeBuild.Inputs.ReportGroupExportConfigArgs
 *         {
 *             Type = "S3",
 *             S3Destination = new Aws.CodeBuild.Inputs.ReportGroupExportConfigS3DestinationArgs
 *             {
 *                 Bucket = exampleBucketV2.Id,
 *                 EncryptionDisabled = false,
 *                 EncryptionKey = exampleKey.Arn,
 *                 Packaging = "NONE",
 *                 Path = "/some",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codebuild"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		current, err := aws.GetCallerIdentity(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		example, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid:    pulumi.StringRef("Enable IAM User Permissions"),
 * 					Effect: pulumi.StringRef("Allow"),
 * 					Principals: []iam.GetPolicyDocumentStatementPrincipal{
 * 						{
 * 							Type: "AWS",
 * 							Identifiers: []string{
 * 								fmt.Sprintf("arn:aws:iam::%v:root", current.AccountId),
 * 							},
 * 						},
 * 					},
 * 					Actions: []string{
 * 						"kms:*",
 * 					},
 * 					Resources: []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleKey, err := kms.NewKey(ctx, "example", &kms.KeyArgs{
 * 			Description:          pulumi.String("my test kms key"),
 * 			DeletionWindowInDays: pulumi.Int(7),
 * 			Policy:               pulumi.String(example.Json),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleBucketV2, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = codebuild.NewReportGroup(ctx, "example", &codebuild.ReportGroupArgs{
 * 			Name: pulumi.String("my test report group"),
 * 			Type: pulumi.String("TEST"),
 * 			ExportConfig: &codebuild.ReportGroupExportConfigArgs{
 * 				Type: pulumi.String("S3"),
 * 				S3Destination: &codebuild.ReportGroupExportConfigS3DestinationArgs{
 * 					Bucket:             exampleBucketV2.ID(),
 * 					EncryptionDisabled: pulumi.Bool(false),
 * 					EncryptionKey:      exampleKey.Arn,
 * 					Packaging:          pulumi.String("NONE"),
 * 					Path:               pulumi.String("/some"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetCallerIdentityArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.kms.KeyArgs;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.codebuild.ReportGroup;
 * import com.pulumi.aws.codebuild.ReportGroupArgs;
 * import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigArgs;
 * import com.pulumi.aws.codebuild.inputs.ReportGroupExportConfigS3DestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var current = AwsFunctions.getCallerIdentity();
 *         final var example = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("Enable IAM User Permissions")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers(String.format("arn:aws:iam::%s:root", current.applyValue(getCallerIdentityResult -> getCallerIdentityResult.accountId())))
 *                     .build())
 *                 .actions("kms:*")
 *                 .resources("*")
 *                 .build())
 *             .build());
 *         var exampleKey = new Key("exampleKey", KeyArgs.builder()
 *             .description("my test kms key")
 *             .deletionWindowInDays(7)
 *             .policy(example.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .build());
 *         var exampleBucketV2 = new BucketV2("exampleBucketV2", BucketV2Args.builder()
 *             .bucket("my-test")
 *             .build());
 *         var exampleReportGroup = new ReportGroup("exampleReportGroup", ReportGroupArgs.builder()
 *             .name("my test report group")
 *             .type("TEST")
 *             .exportConfig(ReportGroupExportConfigArgs.builder()
 *                 .type("S3")
 *                 .s3Destination(ReportGroupExportConfigS3DestinationArgs.builder()
 *                     .bucket(exampleBucketV2.id())
 *                     .encryptionDisabled(false)
 *                     .encryptionKey(exampleKey.arn())
 *                     .packaging("NONE")
 *                     .path("/some")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleKey:
 *     type: aws:kms:Key
 *     name: example
 *     properties:
 *       description: my test kms key
 *       deletionWindowInDays: 7
 *       policy: ${example.json}
 *   exampleBucketV2:
 *     type: aws:s3:BucketV2
 *     name: example
 *     properties:
 *       bucket: my-test
 *   exampleReportGroup:
 *     type: aws:codebuild:ReportGroup
 *     name: example
 *     properties:
 *       name: my test report group
 *       type: TEST
 *       exportConfig:
 *         type: S3
 *         s3Destination:
 *           bucket: ${exampleBucketV2.id}
 *           encryptionDisabled: false
 *           encryptionKey: ${exampleKey.arn}
 *           packaging: NONE
 *           path: /some
 * variables:
 *   current:
 *     fn::invoke:
 *       Function: aws:getCallerIdentity
 *       Arguments: {}
 *   example:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: Enable IAM User Permissions
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - arn:aws:iam::${current.accountId}:root
 *             actions:
 *               - kms:*
 *             resources:
 *               - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeBuild Report Group using the CodeBuild Report Group arn. For example:
 * ```sh
 * $ pulumi import aws:codebuild/reportGroup:ReportGroup example arn:aws:codebuild:us-west-2:123456789:report-group/report-group-name
 * ```
 * @property deleteReports If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
 * @property exportConfig Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
 * @property name The name of a Report Group.
 * @property tags Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
 */
public data class ReportGroupArgs(
    public val deleteReports: Output<Boolean>? = null,
    public val exportConfig: Output<ReportGroupExportConfigArgs>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.ReportGroupArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.ReportGroupArgs =
        com.pulumi.aws.codebuild.ReportGroupArgs.builder()
            .deleteReports(deleteReports?.applyValue({ args0 -> args0 }))
            .exportConfig(exportConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ReportGroupArgs].
 */
@PulumiTagMarker
public class ReportGroupArgsBuilder internal constructor() {
    private var deleteReports: Output<Boolean>? = null

    private var exportConfig: Output<ReportGroupExportConfigArgs>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
     */
    @JvmName("cuangxhgiognlebn")
    public suspend fun deleteReports(`value`: Output<Boolean>) {
        this.deleteReports = value
    }

    /**
     * @param value Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
     */
    @JvmName("lpuavcgabanmdrfy")
    public suspend fun exportConfig(`value`: Output<ReportGroupExportConfigArgs>) {
        this.exportConfig = value
    }

    /**
     * @param value The name of a Report Group.
     */
    @JvmName("fkyjhirmejytjqtu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ilsaemjirshppglx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
     */
    @JvmName("nsuwbsxuhtdhteuv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value If `true`, deletes any reports that belong to a report group before deleting the report group. If `false`, you must delete any reports in the report group before deleting it. Default value is `false`.
     */
    @JvmName("csbnloxqjwaqhykn")
    public suspend fun deleteReports(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteReports = mapped
    }

    /**
     * @param value Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
     */
    @JvmName("ritkchqlhruhwami")
    public suspend fun exportConfig(`value`: ReportGroupExportConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exportConfig = mapped
    }

    /**
     * @param argument Information about the destination where the raw data of this Report Group is exported. see Export Config documented below.
     */
    @JvmName("otkkeiialbkecjpa")
    public suspend fun exportConfig(argument: suspend ReportGroupExportConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ReportGroupExportConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.exportConfig = mapped
    }

    /**
     * @param value The name of a Report Group.
     */
    @JvmName("jabanofonmnjedpq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jhbsolnrlqtycamm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wpxumxjwibdufmvc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of the Report Group. Valid value are `TEST` and `CODE_COVERAGE`.
     */
    @JvmName("xxhhlhkgrsnxdqcg")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReportGroupArgs = ReportGroupArgs(
        deleteReports = deleteReports,
        exportConfig = exportConfig,
        name = name,
        tags = tags,
        type = type,
    )
}
