@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.kotlin.outputs.WebhookFilterGroup
import com.pulumi.aws.codebuild.kotlin.outputs.WebhookScopeConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.codebuild.kotlin.outputs.WebhookFilterGroup.Companion.toKotlin as webhookFilterGroupToKotlin
import com.pulumi.aws.codebuild.kotlin.outputs.WebhookScopeConfiguration.Companion.toKotlin as webhookScopeConfigurationToKotlin

/**
 * Builder for [Webhook].
 */
@PulumiTagMarker
public class WebhookResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebhookArgs = WebhookArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WebhookArgsBuilder.() -> Unit) {
        val builder = WebhookArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Webhook {
        val builtJavaResource = com.pulumi.aws.codebuild.Webhook(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Webhook(builtJavaResource)
    }
}

/**
 * Manages a CodeBuild webhook, which is an endpoint accepted by the CodeBuild service to trigger builds from source code repositories. Depending on the source type of the CodeBuild project, the CodeBuild service may also automatically create and delete the actual repository webhook as well.
 * ## Example Usage
 * ### Bitbucket and GitHub
 * When working with [Bitbucket](https://bitbucket&#46;org) and [GitHub](https://github.com) source CodeBuild webhooks, the CodeBuild service will automatically create (on `aws.codebuild.Webhook` resource creation) and delete (on `aws.codebuild.Webhook` resource deletion) the Bitbucket/GitHub repository webhook using its granted OAuth permissions. This behavior cannot be controlled by this provider.
 * > **Note:** The AWS account that this provider uses to create this resource *must* have authorized CodeBuild to access Bitbucket/GitHub's OAuth API in each applicable region. This is a manual step that must be done *before* creating webhooks with this resource. If OAuth is not configured, AWS will return an error similar to `ResourceNotFoundException: Could not find access token for server type github`. More information can be found in the CodeBuild User Guide for [Bitbucket](https://docs&#46;aws&#46;amazon&#46;com/codebuild/latest/userguide/sample-bitbucket-pull-request&#46;html) and [GitHub](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-github-pull-request.html).
 * > **Note:** Further managing the automatically created Bitbucket/GitHub webhook with the `bitbucket_hook`/`github_repository_webhook` resource is only possible with importing that resource after creation of the `aws.codebuild.Webhook` resource. The CodeBuild API does not ever provide the `secret` attribute for the `aws.codebuild.Webhook` resource in this scenario.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codebuild.Webhook("example", {
 *     projectName: exampleAwsCodebuildProject.name,
 *     buildType: "BUILD",
 *     filterGroups: [{
 *         filters: [
 *             {
 *                 type: "EVENT",
 *                 pattern: "PUSH",
 *             },
 *             {
 *                 type: "BASE_REF",
 *                 pattern: "master",
 *             },
 *         ],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codebuild.Webhook("example",
 *     project_name=example_aws_codebuild_project["name"],
 *     build_type="BUILD",
 *     filter_groups=[{
 *         "filters": [
 *             {
 *                 "type": "EVENT",
 *                 "pattern": "PUSH",
 *             },
 *             {
 *                 "type": "BASE_REF",
 *                 "pattern": "master",
 *             },
 *         ],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeBuild.Webhook("example", new()
 *     {
 *         ProjectName = exampleAwsCodebuildProject.Name,
 *         BuildType = "BUILD",
 *         FilterGroups = new[]
 *         {
 *             new Aws.CodeBuild.Inputs.WebhookFilterGroupArgs
 *             {
 *                 Filters = new[]
 *                 {
 *                     new Aws.CodeBuild.Inputs.WebhookFilterGroupFilterArgs
 *                     {
 *                         Type = "EVENT",
 *                         Pattern = "PUSH",
 *                     },
 *                     new Aws.CodeBuild.Inputs.WebhookFilterGroupFilterArgs
 *                     {
 *                         Type = "BASE_REF",
 *                         Pattern = "master",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codebuild"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codebuild.NewWebhook(ctx, "example", &codebuild.WebhookArgs{
 * 			ProjectName: pulumi.Any(exampleAwsCodebuildProject.Name),
 * 			BuildType:   pulumi.String("BUILD"),
 * 			FilterGroups: codebuild.WebhookFilterGroupArray{
 * 				&codebuild.WebhookFilterGroupArgs{
 * 					Filters: codebuild.WebhookFilterGroupFilterArray{
 * 						&codebuild.WebhookFilterGroupFilterArgs{
 * 							Type:    pulumi.String("EVENT"),
 * 							Pattern: pulumi.String("PUSH"),
 * 						},
 * 						&codebuild.WebhookFilterGroupFilterArgs{
 * 							Type:    pulumi.String("BASE_REF"),
 * 							Pattern: pulumi.String("master"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.Webhook;
 * import com.pulumi.aws.codebuild.WebhookArgs;
 * import com.pulumi.aws.codebuild.inputs.WebhookFilterGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Webhook("example", WebhookArgs.builder()
 *             .projectName(exampleAwsCodebuildProject.name())
 *             .buildType("BUILD")
 *             .filterGroups(WebhookFilterGroupArgs.builder()
 *                 .filters(
 *                     WebhookFilterGroupFilterArgs.builder()
 *                         .type("EVENT")
 *                         .pattern("PUSH")
 *                         .build(),
 *                     WebhookFilterGroupFilterArgs.builder()
 *                         .type("BASE_REF")
 *                         .pattern("master")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codebuild:Webhook
 *     properties:
 *       projectName: ${exampleAwsCodebuildProject.name}
 *       buildType: BUILD
 *       filterGroups:
 *         - filters:
 *             - type: EVENT
 *               pattern: PUSH
 *             - type: BASE_REF
 *               pattern: master
 * ```
 * <!--End PulumiCodeChooser -->
 * ### GitHub Enterprise
 * When working with [GitHub Enterprise](https://enterprise.github.com/) source CodeBuild webhooks, the GHE repository webhook must be separately managed (e.g., manually or with the `github_repository_webhook` resource).
 * More information creating webhooks with GitHub Enterprise can be found in the [CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-github-enterprise.html).
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codebuild:Webhook
 *     properties:
 *       projectName: ${exampleAwsCodebuildProject.name}
 *   exampleRepositoryWebhook:
 *     type: github:RepositoryWebhook
 *     name: example
 *     properties:
 *       active: true
 *       events:
 *         - push
 *       name: example
 *       repository: ${exampleGithubRepository.name}
 *       configuration:
 *         url: ${example.payloadUrl}
 *         secret: ${example.secret}
 *         contentType: json
 *         insecureSsl: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeBuild Webhooks using the CodeBuild Project name. For example:
 * ```sh
 * $ pulumi import aws:codebuild/webhook:Webhook example MyProjectName
 * ```
 */
public class Webhook internal constructor(
    override val javaResource: com.pulumi.aws.codebuild.Webhook,
) : KotlinCustomResource(javaResource, WebhookMapper) {
    /**
     * A regular expression used to determine which branches get built. Default is all branches are built. We recommend using `filter_group` over `branch_filter`.
     */
    public val branchFilter: Output<String>?
        get() = javaResource.branchFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of build this webhook will trigger. Valid values for this parameter are: `BUILD`, `BUILD_BATCH`.
     */
    public val buildType: Output<String>?
        get() = javaResource.buildType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Information about the webhook's trigger. Filter group blocks are documented below.
     */
    public val filterGroups: Output<List<WebhookFilterGroup>>?
        get() = javaResource.filterGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> webhookFilterGroupToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The CodeBuild endpoint where webhook events are sent.
     */
    public val payloadUrl: Output<String>
        get() = javaResource.payloadUrl().applyValue({ args0 -> args0 })

    /**
     * The name of the build project.
     */
    public val projectName: Output<String>
        get() = javaResource.projectName().applyValue({ args0 -> args0 })

    /**
     * Scope configuration for global or organization webhooks. Scope configuration blocks are documented below.
     */
    public val scopeConfiguration: Output<WebhookScopeConfiguration>?
        get() = javaResource.scopeConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> webhookScopeConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The secret token of the associated repository. Not returned by the CodeBuild API for all source types.
     */
    public val secret: Output<String>
        get() = javaResource.secret().applyValue({ args0 -> args0 })

    /**
     * The URL to the webhook.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object WebhookMapper : ResourceMapper<Webhook> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.codebuild.Webhook::class == javaResource::class

    override fun map(javaResource: Resource): Webhook = Webhook(
        javaResource as
            com.pulumi.aws.codebuild.Webhook,
    )
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Webhook].
 */
public suspend fun webhook(name: String, block: suspend WebhookResourceBuilder.() -> Unit): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Webhook].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webhook(name: String): Webhook {
    val builder = WebhookResourceBuilder()
    builder.name(name)
    return builder.build()
}
