@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin

import com.pulumi.aws.codebuild.WebhookArgs.builder
import com.pulumi.aws.codebuild.kotlin.inputs.WebhookFilterGroupArgs
import com.pulumi.aws.codebuild.kotlin.inputs.WebhookFilterGroupArgsBuilder
import com.pulumi.aws.codebuild.kotlin.inputs.WebhookScopeConfigurationArgs
import com.pulumi.aws.codebuild.kotlin.inputs.WebhookScopeConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Manages a CodeBuild webhook, which is an endpoint accepted by the CodeBuild service to trigger builds from source code repositories. Depending on the source type of the CodeBuild project, the CodeBuild service may also automatically create and delete the actual repository webhook as well.
 * ## Example Usage
 * ### Bitbucket and GitHub
 * When working with [Bitbucket](https://bitbucket&#46;org) and [GitHub](https://github.com) source CodeBuild webhooks, the CodeBuild service will automatically create (on `aws.codebuild.Webhook` resource creation) and delete (on `aws.codebuild.Webhook` resource deletion) the Bitbucket/GitHub repository webhook using its granted OAuth permissions. This behavior cannot be controlled by this provider.
 * > **Note:** The AWS account that this provider uses to create this resource *must* have authorized CodeBuild to access Bitbucket/GitHub's OAuth API in each applicable region. This is a manual step that must be done *before* creating webhooks with this resource. If OAuth is not configured, AWS will return an error similar to `ResourceNotFoundException: Could not find access token for server type github`. More information can be found in the CodeBuild User Guide for [Bitbucket](https://docs&#46;aws&#46;amazon&#46;com/codebuild/latest/userguide/sample-bitbucket-pull-request&#46;html) and [GitHub](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-github-pull-request.html).
 * > **Note:** Further managing the automatically created Bitbucket/GitHub webhook with the `bitbucket_hook`/`github_repository_webhook` resource is only possible with importing that resource after creation of the `aws.codebuild.Webhook` resource. The CodeBuild API does not ever provide the `secret` attribute for the `aws.codebuild.Webhook` resource in this scenario.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.codebuild.Webhook("example", {
 *     projectName: exampleAwsCodebuildProject.name,
 *     buildType: "BUILD",
 *     filterGroups: [{
 *         filters: [
 *             {
 *                 type: "EVENT",
 *                 pattern: "PUSH",
 *             },
 *             {
 *                 type: "BASE_REF",
 *                 pattern: "master",
 *             },
 *         ],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.codebuild.Webhook("example",
 *     project_name=example_aws_codebuild_project["name"],
 *     build_type="BUILD",
 *     filter_groups=[{
 *         "filters": [
 *             {
 *                 "type": "EVENT",
 *                 "pattern": "PUSH",
 *             },
 *             {
 *                 "type": "BASE_REF",
 *                 "pattern": "master",
 *             },
 *         ],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.CodeBuild.Webhook("example", new()
 *     {
 *         ProjectName = exampleAwsCodebuildProject.Name,
 *         BuildType = "BUILD",
 *         FilterGroups = new[]
 *         {
 *             new Aws.CodeBuild.Inputs.WebhookFilterGroupArgs
 *             {
 *                 Filters = new[]
 *                 {
 *                     new Aws.CodeBuild.Inputs.WebhookFilterGroupFilterArgs
 *                     {
 *                         Type = "EVENT",
 *                         Pattern = "PUSH",
 *                     },
 *                     new Aws.CodeBuild.Inputs.WebhookFilterGroupFilterArgs
 *                     {
 *                         Type = "BASE_REF",
 *                         Pattern = "master",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/codebuild"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := codebuild.NewWebhook(ctx, "example", &codebuild.WebhookArgs{
 * 			ProjectName: pulumi.Any(exampleAwsCodebuildProject.Name),
 * 			BuildType:   pulumi.String("BUILD"),
 * 			FilterGroups: codebuild.WebhookFilterGroupArray{
 * 				&codebuild.WebhookFilterGroupArgs{
 * 					Filters: codebuild.WebhookFilterGroupFilterArray{
 * 						&codebuild.WebhookFilterGroupFilterArgs{
 * 							Type:    pulumi.String("EVENT"),
 * 							Pattern: pulumi.String("PUSH"),
 * 						},
 * 						&codebuild.WebhookFilterGroupFilterArgs{
 * 							Type:    pulumi.String("BASE_REF"),
 * 							Pattern: pulumi.String("master"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.codebuild.Webhook;
 * import com.pulumi.aws.codebuild.WebhookArgs;
 * import com.pulumi.aws.codebuild.inputs.WebhookFilterGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Webhook("example", WebhookArgs.builder()
 *             .projectName(exampleAwsCodebuildProject.name())
 *             .buildType("BUILD")
 *             .filterGroups(WebhookFilterGroupArgs.builder()
 *                 .filters(
 *                     WebhookFilterGroupFilterArgs.builder()
 *                         .type("EVENT")
 *                         .pattern("PUSH")
 *                         .build(),
 *                     WebhookFilterGroupFilterArgs.builder()
 *                         .type("BASE_REF")
 *                         .pattern("master")
 *                         .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codebuild:Webhook
 *     properties:
 *       projectName: ${exampleAwsCodebuildProject.name}
 *       buildType: BUILD
 *       filterGroups:
 *         - filters:
 *             - type: EVENT
 *               pattern: PUSH
 *             - type: BASE_REF
 *               pattern: master
 * ```
 * <!--End PulumiCodeChooser -->
 * ### GitHub Enterprise
 * When working with [GitHub Enterprise](https://enterprise.github.com/) source CodeBuild webhooks, the GHE repository webhook must be separately managed (e.g., manually or with the `github_repository_webhook` resource).
 * More information creating webhooks with GitHub Enterprise can be found in the [CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/sample-github-enterprise.html).
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:codebuild:Webhook
 *     properties:
 *       projectName: ${exampleAwsCodebuildProject.name}
 *   exampleRepositoryWebhook:
 *     type: github:RepositoryWebhook
 *     name: example
 *     properties:
 *       active: true
 *       events:
 *         - push
 *       name: example
 *       repository: ${exampleGithubRepository.name}
 *       configuration:
 *         url: ${example.payloadUrl}
 *         secret: ${example.secret}
 *         contentType: json
 *         insecureSsl: false
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import CodeBuild Webhooks using the CodeBuild Project name. For example:
 * ```sh
 * $ pulumi import aws:codebuild/webhook:Webhook example MyProjectName
 * ```
 * @property branchFilter A regular expression used to determine which branches get built. Default is all branches are built. We recommend using `filter_group` over `branch_filter`.
 * @property buildType The type of build this webhook will trigger. Valid values for this parameter are: `BUILD`, `BUILD_BATCH`.
 * @property filterGroups Information about the webhook's trigger. Filter group blocks are documented below.
 * @property projectName The name of the build project.
 * @property scopeConfiguration Scope configuration for global or organization webhooks. Scope configuration blocks are documented below.
 */
public data class WebhookArgs(
    public val branchFilter: Output<String>? = null,
    public val buildType: Output<String>? = null,
    public val filterGroups: Output<List<WebhookFilterGroupArgs>>? = null,
    public val projectName: Output<String>? = null,
    public val scopeConfiguration: Output<WebhookScopeConfigurationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.WebhookArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.WebhookArgs =
        com.pulumi.aws.codebuild.WebhookArgs.builder()
            .branchFilter(branchFilter?.applyValue({ args0 -> args0 }))
            .buildType(buildType?.applyValue({ args0 -> args0 }))
            .filterGroups(
                filterGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .projectName(projectName?.applyValue({ args0 -> args0 }))
            .scopeConfiguration(
                scopeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [WebhookArgs].
 */
@PulumiTagMarker
public class WebhookArgsBuilder internal constructor() {
    private var branchFilter: Output<String>? = null

    private var buildType: Output<String>? = null

    private var filterGroups: Output<List<WebhookFilterGroupArgs>>? = null

    private var projectName: Output<String>? = null

    private var scopeConfiguration: Output<WebhookScopeConfigurationArgs>? = null

    /**
     * @param value A regular expression used to determine which branches get built. Default is all branches are built. We recommend using `filter_group` over `branch_filter`.
     */
    @JvmName("lriltaedmxkngujg")
    public suspend fun branchFilter(`value`: Output<String>) {
        this.branchFilter = value
    }

    /**
     * @param value The type of build this webhook will trigger. Valid values for this parameter are: `BUILD`, `BUILD_BATCH`.
     */
    @JvmName("wbkdhvpyvegosmsf")
    public suspend fun buildType(`value`: Output<String>) {
        this.buildType = value
    }

    /**
     * @param value Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("shaqcfxdvocteboh")
    public suspend fun filterGroups(`value`: Output<List<WebhookFilterGroupArgs>>) {
        this.filterGroups = value
    }

    @JvmName("gnobkxpgpapafbhe")
    public suspend fun filterGroups(vararg values: Output<WebhookFilterGroupArgs>) {
        this.filterGroups = Output.all(values.asList())
    }

    /**
     * @param values Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("afnvhyossfhcvpsl")
    public suspend fun filterGroups(values: List<Output<WebhookFilterGroupArgs>>) {
        this.filterGroups = Output.all(values)
    }

    /**
     * @param value The name of the build project.
     */
    @JvmName("loltaixtophhqcjt")
    public suspend fun projectName(`value`: Output<String>) {
        this.projectName = value
    }

    /**
     * @param value Scope configuration for global or organization webhooks. Scope configuration blocks are documented below.
     */
    @JvmName("ouxwoqokxjokfpos")
    public suspend fun scopeConfiguration(`value`: Output<WebhookScopeConfigurationArgs>) {
        this.scopeConfiguration = value
    }

    /**
     * @param value A regular expression used to determine which branches get built. Default is all branches are built. We recommend using `filter_group` over `branch_filter`.
     */
    @JvmName("hqwxxrqeorrpfmon")
    public suspend fun branchFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.branchFilter = mapped
    }

    /**
     * @param value The type of build this webhook will trigger. Valid values for this parameter are: `BUILD`, `BUILD_BATCH`.
     */
    @JvmName("fyqouxvcmhcdltch")
    public suspend fun buildType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildType = mapped
    }

    /**
     * @param value Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("fssfglfylnbtbyds")
    public suspend fun filterGroups(`value`: List<WebhookFilterGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterGroups = mapped
    }

    /**
     * @param argument Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("rmapdwigfjndwqwv")
    public suspend fun filterGroups(argument: List<suspend WebhookFilterGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            WebhookFilterGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filterGroups = mapped
    }

    /**
     * @param argument Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("gjmsuftvulvsxigj")
    public suspend fun filterGroups(vararg argument: suspend WebhookFilterGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            WebhookFilterGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.filterGroups = mapped
    }

    /**
     * @param argument Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("mmxymjnnxtrpdpxh")
    public suspend fun filterGroups(argument: suspend WebhookFilterGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(WebhookFilterGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.filterGroups = mapped
    }

    /**
     * @param values Information about the webhook's trigger. Filter group blocks are documented below.
     */
    @JvmName("rynrdktuudhwarvu")
    public suspend fun filterGroups(vararg values: WebhookFilterGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterGroups = mapped
    }

    /**
     * @param value The name of the build project.
     */
    @JvmName("mplowfdlwbomtxpi")
    public suspend fun projectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectName = mapped
    }

    /**
     * @param value Scope configuration for global or organization webhooks. Scope configuration blocks are documented below.
     */
    @JvmName("gfripcvjvnrxdnqs")
    public suspend fun scopeConfiguration(`value`: WebhookScopeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scopeConfiguration = mapped
    }

    /**
     * @param argument Scope configuration for global or organization webhooks. Scope configuration blocks are documented below.
     */
    @JvmName("ddbkpopawvlkykhw")
    public suspend fun scopeConfiguration(argument: suspend WebhookScopeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = WebhookScopeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.scopeConfiguration = mapped
    }

    internal fun build(): WebhookArgs = WebhookArgs(
        branchFilter = branchFilter,
        buildType = buildType,
        filterGroups = filterGroups,
        projectName = projectName,
        scopeConfiguration = scopeConfiguration,
    )
}
