@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property combineArtifacts Specifies if the build artifacts for the batch build should be combined into a single artifact location.
 * @property restrictions Configuration block specifying the restrictions for the batch build. Detailed below.
 * @property serviceRole Specifies the service role ARN for the batch build project.
 * @property timeoutInMins Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
 */
public data class ProjectBuildBatchConfigArgs(
    public val combineArtifacts: Output<Boolean>? = null,
    public val restrictions: Output<ProjectBuildBatchConfigRestrictionsArgs>? = null,
    public val serviceRole: Output<String>,
    public val timeoutInMins: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigArgs =
        com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigArgs.builder()
            .combineArtifacts(combineArtifacts?.applyValue({ args0 -> args0 }))
            .restrictions(restrictions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serviceRole(serviceRole.applyValue({ args0 -> args0 }))
            .timeoutInMins(timeoutInMins?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectBuildBatchConfigArgs].
 */
@PulumiTagMarker
public class ProjectBuildBatchConfigArgsBuilder internal constructor() {
    private var combineArtifacts: Output<Boolean>? = null

    private var restrictions: Output<ProjectBuildBatchConfigRestrictionsArgs>? = null

    private var serviceRole: Output<String>? = null

    private var timeoutInMins: Output<Int>? = null

    /**
     * @param value Specifies if the build artifacts for the batch build should be combined into a single artifact location.
     */
    @JvmName("kkjhcsqooymudeaw")
    public suspend fun combineArtifacts(`value`: Output<Boolean>) {
        this.combineArtifacts = value
    }

    /**
     * @param value Configuration block specifying the restrictions for the batch build. Detailed below.
     */
    @JvmName("cnhwpetuhdhclwjv")
    public suspend fun restrictions(`value`: Output<ProjectBuildBatchConfigRestrictionsArgs>) {
        this.restrictions = value
    }

    /**
     * @param value Specifies the service role ARN for the batch build project.
     */
    @JvmName("thsocxswdktanhdy")
    public suspend fun serviceRole(`value`: Output<String>) {
        this.serviceRole = value
    }

    /**
     * @param value Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
     */
    @JvmName("bystdnbshjreuqrd")
    public suspend fun timeoutInMins(`value`: Output<Int>) {
        this.timeoutInMins = value
    }

    /**
     * @param value Specifies if the build artifacts for the batch build should be combined into a single artifact location.
     */
    @JvmName("rhpkamvymvmjobsm")
    public suspend fun combineArtifacts(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.combineArtifacts = mapped
    }

    /**
     * @param value Configuration block specifying the restrictions for the batch build. Detailed below.
     */
    @JvmName("tnrmhfrevydfihkn")
    public suspend fun restrictions(`value`: ProjectBuildBatchConfigRestrictionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restrictions = mapped
    }

    /**
     * @param argument Configuration block specifying the restrictions for the batch build. Detailed below.
     */
    @JvmName("cdnuyrhhdjhrwexw")
    public suspend fun restrictions(argument: suspend ProjectBuildBatchConfigRestrictionsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectBuildBatchConfigRestrictionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.restrictions = mapped
    }

    /**
     * @param value Specifies the service role ARN for the batch build project.
     */
    @JvmName("moxscxgxflawdgfh")
    public suspend fun serviceRole(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceRole = mapped
    }

    /**
     * @param value Specifies the maximum amount of time, in minutes, that the batch build must be completed in.
     */
    @JvmName("uxohnagaiihifmow")
    public suspend fun timeoutInMins(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInMins = mapped
    }

    internal fun build(): ProjectBuildBatchConfigArgs = ProjectBuildBatchConfigArgs(
        combineArtifacts = combineArtifacts,
        restrictions = restrictions,
        serviceRole = serviceRole ?: throw PulumiNullFieldException("serviceRole"),
        timeoutInMins = timeoutInMins,
    )
}
