@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigRestrictionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property computeTypesAlloweds An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
 * @property maximumBuildsAllowed Specifies the maximum number of builds allowed.
 */
public data class ProjectBuildBatchConfigRestrictionsArgs(
    public val computeTypesAlloweds: Output<List<String>>? = null,
    public val maximumBuildsAllowed: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigRestrictionsArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigRestrictionsArgs =
        com.pulumi.aws.codebuild.inputs.ProjectBuildBatchConfigRestrictionsArgs.builder()
            .computeTypesAlloweds(computeTypesAlloweds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maximumBuildsAllowed(maximumBuildsAllowed?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectBuildBatchConfigRestrictionsArgs].
 */
@PulumiTagMarker
public class ProjectBuildBatchConfigRestrictionsArgsBuilder internal constructor() {
    private var computeTypesAlloweds: Output<List<String>>? = null

    private var maximumBuildsAllowed: Output<Int>? = null

    /**
     * @param value An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
     */
    @JvmName("yljojeqobrxwgmeb")
    public suspend fun computeTypesAlloweds(`value`: Output<List<String>>) {
        this.computeTypesAlloweds = value
    }

    @JvmName("drjgogymruapbltj")
    public suspend fun computeTypesAlloweds(vararg values: Output<String>) {
        this.computeTypesAlloweds = Output.all(values.asList())
    }

    /**
     * @param values An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
     */
    @JvmName("xlfddhdhpgcrkynl")
    public suspend fun computeTypesAlloweds(values: List<Output<String>>) {
        this.computeTypesAlloweds = Output.all(values)
    }

    /**
     * @param value Specifies the maximum number of builds allowed.
     */
    @JvmName("gsbtwqttwnihsmgb")
    public suspend fun maximumBuildsAllowed(`value`: Output<Int>) {
        this.maximumBuildsAllowed = value
    }

    /**
     * @param value An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
     */
    @JvmName("mtcxoicsrsyujhlr")
    public suspend fun computeTypesAlloweds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeTypesAlloweds = mapped
    }

    /**
     * @param values An array of strings that specify the compute types that are allowed for the batch build. See [Build environment compute types](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html) in the AWS CodeBuild User Guide for these values.
     */
    @JvmName("xpgpfaaakxhixtet")
    public suspend fun computeTypesAlloweds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeTypesAlloweds = mapped
    }

    /**
     * @param value Specifies the maximum number of builds allowed.
     */
    @JvmName("swleftdboxxrwove")
    public suspend fun maximumBuildsAllowed(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumBuildsAllowed = mapped
    }

    internal fun build(): ProjectBuildBatchConfigRestrictionsArgs =
        ProjectBuildBatchConfigRestrictionsArgs(
            computeTypesAlloweds = computeTypesAlloweds,
            maximumBuildsAllowed = maximumBuildsAllowed,
        )
}
