@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property certificate ARN of the S3 bucket, path prefix and object key that contains the PEM-encoded certificate.
 * @property computeType Information about the compute resources the build project will use. Valid values: `BUILD_GENERAL1_SMALL`, `BUILD_GENERAL1_MEDIUM`, `BUILD_GENERAL1_LARGE`, `BUILD_GENERAL1_2XLARGE`, `BUILD_LAMBDA_1GB`, `BUILD_LAMBDA_2GB`, `BUILD_LAMBDA_4GB`, `BUILD_LAMBDA_8GB`, `BUILD_LAMBDA_10GB`. `BUILD_GENERAL1_SMALL` is only valid if `type` is set to `LINUX_CONTAINER`. When `type` is set to `LINUX_GPU_CONTAINER`, `compute_type` must be `BUILD_GENERAL1_LARGE`. When `type` is set to `LINUX_LAMBDA_CONTAINER` or `ARM_LAMBDA_CONTAINER`, `compute_type` must be `BUILD_LAMBDA_XGB`.`
 * @property environmentVariables Configuration block. Detailed below.
 * @property image Docker image to use for this build project. Valid values include Docker images provided by CodeBuild, and full Docker repository URIs such as those for ECR (e.g., `137112412989.dkr.ecr.us-west-2.amazonaws.com/amazonlinux:latest`).
 * @property imagePullCredentialsType Type of credentials AWS CodeBuild uses to pull images in your build. Valid values: `CODEBUILD`, `SERVICE_ROLE`. When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CodeBuild credentials. Defaults to `CODEBUILD`.
 * @property privilegedMode Whether to enable running the Docker daemon inside a Docker container. Defaults to `false`.
 * @property registryCredential Configuration block. Detailed below.
 * @property type Type of build environment to use for related builds. Valid values: `LINUX_CONTAINER`, `LINUX_GPU_CONTAINER`, `WINDOWS_CONTAINER` (deprecated), `WINDOWS_SERVER_2019_CONTAINER`, `ARM_CONTAINER`, `LINUX_LAMBDA_CONTAINER`, `ARM_LAMBDA_CONTAINER`. For additional information, see the [CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html).
 */
public data class ProjectEnvironmentArgs(
    public val certificate: Output<String>? = null,
    public val computeType: Output<String>,
    public val environmentVariables: Output<List<ProjectEnvironmentEnvironmentVariableArgs>>? = null,
    public val image: Output<String>,
    public val imagePullCredentialsType: Output<String>? = null,
    public val privilegedMode: Output<Boolean>? = null,
    public val registryCredential: Output<ProjectEnvironmentRegistryCredentialArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs =
        com.pulumi.aws.codebuild.inputs.ProjectEnvironmentArgs.builder()
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .computeType(computeType.applyValue({ args0 -> args0 }))
            .environmentVariables(
                environmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .image(image.applyValue({ args0 -> args0 }))
            .imagePullCredentialsType(imagePullCredentialsType?.applyValue({ args0 -> args0 }))
            .privilegedMode(privilegedMode?.applyValue({ args0 -> args0 }))
            .registryCredential(
                registryCredential?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectEnvironmentArgs].
 */
@PulumiTagMarker
public class ProjectEnvironmentArgsBuilder internal constructor() {
    private var certificate: Output<String>? = null

    private var computeType: Output<String>? = null

    private var environmentVariables: Output<List<ProjectEnvironmentEnvironmentVariableArgs>>? = null

    private var image: Output<String>? = null

    private var imagePullCredentialsType: Output<String>? = null

    private var privilegedMode: Output<Boolean>? = null

    private var registryCredential: Output<ProjectEnvironmentRegistryCredentialArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value ARN of the S3 bucket, path prefix and object key that contains the PEM-encoded certificate.
     */
    @JvmName("keuaujqfwmcghcvw")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value Information about the compute resources the build project will use. Valid values: `BUILD_GENERAL1_SMALL`, `BUILD_GENERAL1_MEDIUM`, `BUILD_GENERAL1_LARGE`, `BUILD_GENERAL1_2XLARGE`, `BUILD_LAMBDA_1GB`, `BUILD_LAMBDA_2GB`, `BUILD_LAMBDA_4GB`, `BUILD_LAMBDA_8GB`, `BUILD_LAMBDA_10GB`. `BUILD_GENERAL1_SMALL` is only valid if `type` is set to `LINUX_CONTAINER`. When `type` is set to `LINUX_GPU_CONTAINER`, `compute_type` must be `BUILD_GENERAL1_LARGE`. When `type` is set to `LINUX_LAMBDA_CONTAINER` or `ARM_LAMBDA_CONTAINER`, `compute_type` must be `BUILD_LAMBDA_XGB`.`
     */
    @JvmName("rprvhvlrncyokhug")
    public suspend fun computeType(`value`: Output<String>) {
        this.computeType = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("ijhlaiixoxxhomit")
    public suspend fun environmentVariables(`value`: Output<List<ProjectEnvironmentEnvironmentVariableArgs>>) {
        this.environmentVariables = value
    }

    @JvmName("srrdgctxaloiuyme")
    public suspend fun environmentVariables(vararg values: Output<ProjectEnvironmentEnvironmentVariableArgs>) {
        this.environmentVariables = Output.all(values.asList())
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("arybneoooogapgwi")
    public suspend fun environmentVariables(values: List<Output<ProjectEnvironmentEnvironmentVariableArgs>>) {
        this.environmentVariables = Output.all(values)
    }

    /**
     * @param value Docker image to use for this build project. Valid values include Docker images provided by CodeBuild, and full Docker repository URIs such as those for ECR (e.g., `137112412989.dkr.ecr.us-west-2.amazonaws.com/amazonlinux:latest`).
     */
    @JvmName("sswahuahnebcbcxx")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Type of credentials AWS CodeBuild uses to pull images in your build. Valid values: `CODEBUILD`, `SERVICE_ROLE`. When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CodeBuild credentials. Defaults to `CODEBUILD`.
     */
    @JvmName("xlaabugiadcvksmm")
    public suspend fun imagePullCredentialsType(`value`: Output<String>) {
        this.imagePullCredentialsType = value
    }

    /**
     * @param value Whether to enable running the Docker daemon inside a Docker container. Defaults to `false`.
     */
    @JvmName("bsnvfwhckurdfjpv")
    public suspend fun privilegedMode(`value`: Output<Boolean>) {
        this.privilegedMode = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("ffbnfrvygxegagon")
    public suspend fun registryCredential(`value`: Output<ProjectEnvironmentRegistryCredentialArgs>) {
        this.registryCredential = value
    }

    /**
     * @param value Type of build environment to use for related builds. Valid values: `LINUX_CONTAINER`, `LINUX_GPU_CONTAINER`, `WINDOWS_CONTAINER` (deprecated), `WINDOWS_SERVER_2019_CONTAINER`, `ARM_CONTAINER`, `LINUX_LAMBDA_CONTAINER`, `ARM_LAMBDA_CONTAINER`. For additional information, see the [CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html).
     */
    @JvmName("uvqxbgceomysjuer")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ARN of the S3 bucket, path prefix and object key that contains the PEM-encoded certificate.
     */
    @JvmName("bhnyohoyckvewkhf")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value Information about the compute resources the build project will use. Valid values: `BUILD_GENERAL1_SMALL`, `BUILD_GENERAL1_MEDIUM`, `BUILD_GENERAL1_LARGE`, `BUILD_GENERAL1_2XLARGE`, `BUILD_LAMBDA_1GB`, `BUILD_LAMBDA_2GB`, `BUILD_LAMBDA_4GB`, `BUILD_LAMBDA_8GB`, `BUILD_LAMBDA_10GB`. `BUILD_GENERAL1_SMALL` is only valid if `type` is set to `LINUX_CONTAINER`. When `type` is set to `LINUX_GPU_CONTAINER`, `compute_type` must be `BUILD_GENERAL1_LARGE`. When `type` is set to `LINUX_LAMBDA_CONTAINER` or `ARM_LAMBDA_CONTAINER`, `compute_type` must be `BUILD_LAMBDA_XGB`.`
     */
    @JvmName("niucvdegdfmnfrkx")
    public suspend fun computeType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.computeType = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("hiwsdcaddchxojtb")
    public suspend fun environmentVariables(`value`: List<ProjectEnvironmentEnvironmentVariableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("qgcoxkyutjpypmye")
    public suspend fun environmentVariables(argument: List<suspend ProjectEnvironmentEnvironmentVariableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ProjectEnvironmentEnvironmentVariableArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("yhlckkokcbsoyjax")
    public suspend fun environmentVariables(vararg argument: suspend ProjectEnvironmentEnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ProjectEnvironmentEnvironmentVariableArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("qaqpuatukixtjdeo")
    public suspend fun environmentVariables(argument: suspend ProjectEnvironmentEnvironmentVariableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ProjectEnvironmentEnvironmentVariableArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.environmentVariables = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("mlcipxgrdqxtbpbu")
    public suspend fun environmentVariables(vararg values: ProjectEnvironmentEnvironmentVariableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.environmentVariables = mapped
    }

    /**
     * @param value Docker image to use for this build project. Valid values include Docker images provided by CodeBuild, and full Docker repository URIs such as those for ECR (e.g., `137112412989.dkr.ecr.us-west-2.amazonaws.com/amazonlinux:latest`).
     */
    @JvmName("aldkqwvdypmdyjfs")
    public suspend fun image(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Type of credentials AWS CodeBuild uses to pull images in your build. Valid values: `CODEBUILD`, `SERVICE_ROLE`. When you use a cross-account or private registry image, you must use SERVICE_ROLE credentials. When you use an AWS CodeBuild curated image, you must use CodeBuild credentials. Defaults to `CODEBUILD`.
     */
    @JvmName("smsjntiamfjpermk")
    public suspend fun imagePullCredentialsType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imagePullCredentialsType = mapped
    }

    /**
     * @param value Whether to enable running the Docker daemon inside a Docker container. Defaults to `false`.
     */
    @JvmName("nfsrqnoqnpadtkcu")
    public suspend fun privilegedMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privilegedMode = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("epxctkqvstvekbxs")
    public suspend fun registryCredential(`value`: ProjectEnvironmentRegistryCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.registryCredential = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("wpxwmriftofovvie")
    public suspend fun registryCredential(argument: suspend ProjectEnvironmentRegistryCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectEnvironmentRegistryCredentialArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.registryCredential = mapped
    }

    /**
     * @param value Type of build environment to use for related builds. Valid values: `LINUX_CONTAINER`, `LINUX_GPU_CONTAINER`, `WINDOWS_CONTAINER` (deprecated), `WINDOWS_SERVER_2019_CONTAINER`, `ARM_CONTAINER`, `LINUX_LAMBDA_CONTAINER`, `ARM_LAMBDA_CONTAINER`. For additional information, see the [CodeBuild User Guide](https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-compute-types.html).
     */
    @JvmName("fssvbvddaxjyoyns")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProjectEnvironmentArgs = ProjectEnvironmentArgs(
        certificate = certificate,
        computeType = computeType ?: throw PulumiNullFieldException("computeType"),
        environmentVariables = environmentVariables,
        image = image ?: throw PulumiNullFieldException("image"),
        imagePullCredentialsType = imagePullCredentialsType,
        privilegedMode = privilegedMode,
        registryCredential = registryCredential,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
