@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentEnvironmentVariableArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Environment variable's name or key.
 * @property type Type of environment variable. Valid values: `PARAMETER_STORE`, `PLAINTEXT`, `SECRETS_MANAGER`.
 * @property value Environment variable's value.
 */
public data class ProjectEnvironmentEnvironmentVariableArgs(
    public val name: Output<String>,
    public val type: Output<String>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectEnvironmentEnvironmentVariableArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectEnvironmentEnvironmentVariableArgs =
        com.pulumi.aws.codebuild.inputs.ProjectEnvironmentEnvironmentVariableArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectEnvironmentEnvironmentVariableArgs].
 */
@PulumiTagMarker
public class ProjectEnvironmentEnvironmentVariableArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Environment variable's name or key.
     */
    @JvmName("vfausxnkrmoqqdbf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of environment variable. Valid values: `PARAMETER_STORE`, `PLAINTEXT`, `SECRETS_MANAGER`.
     */
    @JvmName("fprdtygcqlhgysyf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Environment variable's value.
     */
    @JvmName("mdjbjdaqninkcyro")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Environment variable's name or key.
     */
    @JvmName("jwybbqmmqhyqbjje")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of environment variable. Valid values: `PARAMETER_STORE`, `PLAINTEXT`, `SECRETS_MANAGER`.
     */
    @JvmName("jqqolyvbqxfcsddn")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Environment variable's value.
     */
    @JvmName("whhamftsivqjprun")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ProjectEnvironmentEnvironmentVariableArgs =
        ProjectEnvironmentEnvironmentVariableArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            type = type,
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
