@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectEnvironmentRegistryCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property credential ARN or name of credentials created using AWS Secrets Manager.
 * @property credentialProvider Service that created the credentials to access a private Docker registry. Valid value: `SECRETS_MANAGER` (AWS Secrets Manager).
 */
public data class ProjectEnvironmentRegistryCredentialArgs(
    public val credential: Output<String>,
    public val credentialProvider: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectEnvironmentRegistryCredentialArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectEnvironmentRegistryCredentialArgs =
        com.pulumi.aws.codebuild.inputs.ProjectEnvironmentRegistryCredentialArgs.builder()
            .credential(credential.applyValue({ args0 -> args0 }))
            .credentialProvider(credentialProvider.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectEnvironmentRegistryCredentialArgs].
 */
@PulumiTagMarker
public class ProjectEnvironmentRegistryCredentialArgsBuilder internal constructor() {
    private var credential: Output<String>? = null

    private var credentialProvider: Output<String>? = null

    /**
     * @param value ARN or name of credentials created using AWS Secrets Manager.
     */
    @JvmName("ctxftoxowcftcodf")
    public suspend fun credential(`value`: Output<String>) {
        this.credential = value
    }

    /**
     * @param value Service that created the credentials to access a private Docker registry. Valid value: `SECRETS_MANAGER` (AWS Secrets Manager).
     */
    @JvmName("qqhmtxaqnkrxoyic")
    public suspend fun credentialProvider(`value`: Output<String>) {
        this.credentialProvider = value
    }

    /**
     * @param value ARN or name of credentials created using AWS Secrets Manager.
     */
    @JvmName("yklxfedfdpokdvog")
    public suspend fun credential(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param value Service that created the credentials to access a private Docker registry. Valid value: `SECRETS_MANAGER` (AWS Secrets Manager).
     */
    @JvmName("wvbrhhcgfelbvcnm")
    public suspend fun credentialProvider(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.credentialProvider = mapped
    }

    internal fun build(): ProjectEnvironmentRegistryCredentialArgs =
        ProjectEnvironmentRegistryCredentialArgs(
            credential = credential ?: throw PulumiNullFieldException("credential"),
            credentialProvider = credentialProvider ?: throw PulumiNullFieldException("credentialProvider"),
        )
}
