@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property cloudwatchLogs Configuration block. Detailed below.
 * @property s3Logs Configuration block. Detailed below.
 */
public data class ProjectLogsConfigArgs(
    public val cloudwatchLogs: Output<ProjectLogsConfigCloudwatchLogsArgs>? = null,
    public val s3Logs: Output<ProjectLogsConfigS3LogsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs =
        com.pulumi.aws.codebuild.inputs.ProjectLogsConfigArgs.builder()
            .cloudwatchLogs(cloudwatchLogs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .s3Logs(s3Logs?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ProjectLogsConfigArgs].
 */
@PulumiTagMarker
public class ProjectLogsConfigArgsBuilder internal constructor() {
    private var cloudwatchLogs: Output<ProjectLogsConfigCloudwatchLogsArgs>? = null

    private var s3Logs: Output<ProjectLogsConfigS3LogsArgs>? = null

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("auveqmjuqgfoaclw")
    public suspend fun cloudwatchLogs(`value`: Output<ProjectLogsConfigCloudwatchLogsArgs>) {
        this.cloudwatchLogs = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("uywrvxkvsmtkmwns")
    public suspend fun s3Logs(`value`: Output<ProjectLogsConfigS3LogsArgs>) {
        this.s3Logs = value
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("hrshwnoljqysvwct")
    public suspend fun cloudwatchLogs(`value`: ProjectLogsConfigCloudwatchLogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudwatchLogs = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("iyicpogohnubwlms")
    public suspend fun cloudwatchLogs(argument: suspend ProjectLogsConfigCloudwatchLogsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectLogsConfigCloudwatchLogsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cloudwatchLogs = mapped
    }

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("jatvfngxmeggqvfd")
    public suspend fun s3Logs(`value`: ProjectLogsConfigS3LogsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Logs = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("qkeijjtdpknwgstl")
    public suspend fun s3Logs(argument: suspend ProjectLogsConfigS3LogsArgsBuilder.() -> Unit) {
        val toBeMapped = ProjectLogsConfigS3LogsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.s3Logs = mapped
    }

    internal fun build(): ProjectLogsConfigArgs = ProjectLogsConfigArgs(
        cloudwatchLogs = cloudwatchLogs,
        s3Logs = s3Logs,
    )
}
