@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigCloudwatchLogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupName Group name of the logs in CloudWatch Logs.
 * @property status Current status of logs in CloudWatch Logs for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `ENABLED`.
 * @property streamName Prefix of the log stream name of the logs in CloudWatch Logs.
 */
public data class ProjectLogsConfigCloudwatchLogsArgs(
    public val groupName: Output<String>? = null,
    public val status: Output<String>? = null,
    public val streamName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectLogsConfigCloudwatchLogsArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectLogsConfigCloudwatchLogsArgs =
        com.pulumi.aws.codebuild.inputs.ProjectLogsConfigCloudwatchLogsArgs.builder()
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .streamName(streamName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectLogsConfigCloudwatchLogsArgs].
 */
@PulumiTagMarker
public class ProjectLogsConfigCloudwatchLogsArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    private var status: Output<String>? = null

    private var streamName: Output<String>? = null

    /**
     * @param value Group name of the logs in CloudWatch Logs.
     */
    @JvmName("xkrfsvwbyvfauyxw")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value Current status of logs in CloudWatch Logs for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `ENABLED`.
     */
    @JvmName("vvcstndwwbtrhxrs")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Prefix of the log stream name of the logs in CloudWatch Logs.
     */
    @JvmName("ahmbxqeqdruulcvx")
    public suspend fun streamName(`value`: Output<String>) {
        this.streamName = value
    }

    /**
     * @param value Group name of the logs in CloudWatch Logs.
     */
    @JvmName("rndidfvwhmabuaut")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value Current status of logs in CloudWatch Logs for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `ENABLED`.
     */
    @JvmName("kspclrcgcoehcfxh")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Prefix of the log stream name of the logs in CloudWatch Logs.
     */
    @JvmName("ajjdbjvqlsubfnut")
    public suspend fun streamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamName = mapped
    }

    internal fun build(): ProjectLogsConfigCloudwatchLogsArgs = ProjectLogsConfigCloudwatchLogsArgs(
        groupName = groupName,
        status = status,
        streamName = streamName,
    )
}
