@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectLogsConfigS3LogsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketOwnerAccess Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
 * @property encryptionDisabled Whether to disable encrypting S3 logs. Defaults to `false`.
 * @property location Name of the S3 bucket and the path prefix for S3 logs. Must be set if status is `ENABLED`, otherwise it must be empty.
 * @property status Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
 */
public data class ProjectLogsConfigS3LogsArgs(
    public val bucketOwnerAccess: Output<String>? = null,
    public val encryptionDisabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectLogsConfigS3LogsArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectLogsConfigS3LogsArgs =
        com.pulumi.aws.codebuild.inputs.ProjectLogsConfigS3LogsArgs.builder()
            .bucketOwnerAccess(bucketOwnerAccess?.applyValue({ args0 -> args0 }))
            .encryptionDisabled(encryptionDisabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectLogsConfigS3LogsArgs].
 */
@PulumiTagMarker
public class ProjectLogsConfigS3LogsArgsBuilder internal constructor() {
    private var bucketOwnerAccess: Output<String>? = null

    private var encryptionDisabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
     */
    @JvmName("annwqysabvajqyts")
    public suspend fun bucketOwnerAccess(`value`: Output<String>) {
        this.bucketOwnerAccess = value
    }

    /**
     * @param value Whether to disable encrypting S3 logs. Defaults to `false`.
     */
    @JvmName("rkgvmwlcuqqsoscg")
    public suspend fun encryptionDisabled(`value`: Output<Boolean>) {
        this.encryptionDisabled = value
    }

    /**
     * @param value Name of the S3 bucket and the path prefix for S3 logs. Must be set if status is `ENABLED`, otherwise it must be empty.
     */
    @JvmName("tqmrbtqyduvlpifn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
     */
    @JvmName("wxdsyaspfgdtndog")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. your CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
     */
    @JvmName("aitwnoujiroiltol")
    public suspend fun bucketOwnerAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketOwnerAccess = mapped
    }

    /**
     * @param value Whether to disable encrypting S3 logs. Defaults to `false`.
     */
    @JvmName("ymistcrugumrhbic")
    public suspend fun encryptionDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionDisabled = mapped
    }

    /**
     * @param value Name of the S3 bucket and the path prefix for S3 logs. Must be set if status is `ENABLED`, otherwise it must be empty.
     */
    @JvmName("gsmgmndjmfxjcpjs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Current status of logs in S3 for a build project. Valid values: `ENABLED`, `DISABLED`. Defaults to `DISABLED`.
     */
    @JvmName("hgmjodxjotlwpdwc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): ProjectLogsConfigS3LogsArgs = ProjectLogsConfigS3LogsArgs(
        bucketOwnerAccess = bucketOwnerAccess,
        encryptionDisabled = encryptionDisabled,
        location = location,
        status = status,
    )
}
