@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectSecondaryArtifactArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property artifactIdentifier Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
 * @property bucketOwnerAccess Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. The CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
 * @property encryptionDisabled Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
 * @property location Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output bucket. If `path` is not specified, `location` can specify the path of the output artifact in the output bucket.
 * @property name Name of the project. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output artifact object.
 * @property namespaceType Namespace to use in storing build artifacts. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `BUILD_ID` or `NONE`.
 * @property overrideArtifactName Whether a name specified in the build specification overrides the artifact name.
 * @property packaging Type of build output artifact to create. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `NONE` or `ZIP`.
 * @property path Along with `namespace_type` and `name`, the pattern that AWS CodeBuild uses to name and store the output artifact. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the path to the output artifact.
 * @property type Build output artifact's type. Valid values `CODEPIPELINE`, `NO_ARTIFACTS`, and `S3`.
 */
public data class ProjectSecondaryArtifactArgs(
    public val artifactIdentifier: Output<String>,
    public val bucketOwnerAccess: Output<String>? = null,
    public val encryptionDisabled: Output<Boolean>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namespaceType: Output<String>? = null,
    public val overrideArtifactName: Output<Boolean>? = null,
    public val packaging: Output<String>? = null,
    public val path: Output<String>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectSecondaryArtifactArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectSecondaryArtifactArgs =
        com.pulumi.aws.codebuild.inputs.ProjectSecondaryArtifactArgs.builder()
            .artifactIdentifier(artifactIdentifier.applyValue({ args0 -> args0 }))
            .bucketOwnerAccess(bucketOwnerAccess?.applyValue({ args0 -> args0 }))
            .encryptionDisabled(encryptionDisabled?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namespaceType(namespaceType?.applyValue({ args0 -> args0 }))
            .overrideArtifactName(overrideArtifactName?.applyValue({ args0 -> args0 }))
            .packaging(packaging?.applyValue({ args0 -> args0 }))
            .path(path?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectSecondaryArtifactArgs].
 */
@PulumiTagMarker
public class ProjectSecondaryArtifactArgsBuilder internal constructor() {
    private var artifactIdentifier: Output<String>? = null

    private var bucketOwnerAccess: Output<String>? = null

    private var encryptionDisabled: Output<Boolean>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var namespaceType: Output<String>? = null

    private var overrideArtifactName: Output<Boolean>? = null

    private var packaging: Output<String>? = null

    private var path: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
     */
    @JvmName("kuxqhhrtwqyruxpi")
    public suspend fun artifactIdentifier(`value`: Output<String>) {
        this.artifactIdentifier = value
    }

    /**
     * @param value Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. The CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
     */
    @JvmName("kpmlsxlyndusijqm")
    public suspend fun bucketOwnerAccess(`value`: Output<String>) {
        this.bucketOwnerAccess = value
    }

    /**
     * @param value Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
     */
    @JvmName("jsnelrlwrhgctovy")
    public suspend fun encryptionDisabled(`value`: Output<Boolean>) {
        this.encryptionDisabled = value
    }

    /**
     * @param value Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output bucket. If `path` is not specified, `location` can specify the path of the output artifact in the output bucket.
     */
    @JvmName("enydsetdpavxdwwc")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the project. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output artifact object.
     */
    @JvmName("aaawhmixvnvsusyl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Namespace to use in storing build artifacts. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `BUILD_ID` or `NONE`.
     */
    @JvmName("ckemwsbqduqcfamr")
    public suspend fun namespaceType(`value`: Output<String>) {
        this.namespaceType = value
    }

    /**
     * @param value Whether a name specified in the build specification overrides the artifact name.
     */
    @JvmName("wjvfbhrpqxeqsnqt")
    public suspend fun overrideArtifactName(`value`: Output<Boolean>) {
        this.overrideArtifactName = value
    }

    /**
     * @param value Type of build output artifact to create. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `NONE` or `ZIP`.
     */
    @JvmName("mwaljivdkdvmhtnw")
    public suspend fun packaging(`value`: Output<String>) {
        this.packaging = value
    }

    /**
     * @param value Along with `namespace_type` and `name`, the pattern that AWS CodeBuild uses to name and store the output artifact. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the path to the output artifact.
     */
    @JvmName("lqwhxkyjxpihragu")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Build output artifact's type. Valid values `CODEPIPELINE`, `NO_ARTIFACTS`, and `S3`.
     */
    @JvmName("xqgskjxokrfwhbnw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Artifact identifier. Must be the same specified inside the AWS CodeBuild build specification.
     */
    @JvmName("yxcretfwcjmulxqh")
    public suspend fun artifactIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.artifactIdentifier = mapped
    }

    /**
     * @param value Specifies the bucket owner's access for objects that another account uploads to their Amazon S3 bucket. By default, only the account that uploads the objects to the bucket has access to these objects. This property allows you to give the bucket owner access to these objects. Valid values are `NONE`, `READ_ONLY`, and `FULL`. The CodeBuild service role must have the `s3:PutBucketAcl` permission. This permission allows CodeBuild to modify the access control list for the bucket.
     */
    @JvmName("jtbilbiixooavwto")
    public suspend fun bucketOwnerAccess(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketOwnerAccess = mapped
    }

    /**
     * @param value Whether to disable encrypting output artifacts. If `type` is set to `NO_ARTIFACTS`, this value is ignored. Defaults to `false`.
     */
    @JvmName("qudnchtovxftlxub")
    public suspend fun encryptionDisabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionDisabled = mapped
    }

    /**
     * @param value Information about the build output artifact location. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output bucket. If `path` is not specified, `location` can specify the path of the output artifact in the output bucket.
     */
    @JvmName("imexiojguliilhfm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the project. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the name of the output artifact object.
     */
    @JvmName("aussuhiykolbovve")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Namespace to use in storing build artifacts. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `BUILD_ID` or `NONE`.
     */
    @JvmName("xnkwmlxoxgpfynce")
    public suspend fun namespaceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceType = mapped
    }

    /**
     * @param value Whether a name specified in the build specification overrides the artifact name.
     */
    @JvmName("dohgqnofthqwqnwj")
    public suspend fun overrideArtifactName(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overrideArtifactName = mapped
    }

    /**
     * @param value Type of build output artifact to create. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, valid values are `NONE` or `ZIP`.
     */
    @JvmName("jidjtbxiycwyeddx")
    public suspend fun packaging(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packaging = mapped
    }

    /**
     * @param value Along with `namespace_type` and `name`, the pattern that AWS CodeBuild uses to name and store the output artifact. If `type` is set to `CODEPIPELINE` or `NO_ARTIFACTS`, this value is ignored if specified. If `type` is set to `S3`, this is the path to the output artifact.
     */
    @JvmName("xewxeepebsoomlkw")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Build output artifact's type. Valid values `CODEPIPELINE`, `NO_ARTIFACTS`, and `S3`.
     */
    @JvmName("uvamtkuuaxyrefhv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ProjectSecondaryArtifactArgs = ProjectSecondaryArtifactArgs(
        artifactIdentifier = artifactIdentifier ?: throw PulumiNullFieldException("artifactIdentifier"),
        bucketOwnerAccess = bucketOwnerAccess,
        encryptionDisabled = encryptionDisabled,
        location = location,
        name = name,
        namespaceType = namespaceType,
        overrideArtifactName = overrideArtifactName,
        packaging = packaging,
        path = path,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
