@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.codebuild.kotlin.inputs

import com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property sourceIdentifier An identifier for a source in the build project.
 * @property sourceVersion The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
 */
public data class ProjectSecondarySourceVersionArgs(
    public val sourceIdentifier: Output<String>,
    public val sourceVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceVersionArgs> {
    override fun toJava(): com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceVersionArgs =
        com.pulumi.aws.codebuild.inputs.ProjectSecondarySourceVersionArgs.builder()
            .sourceIdentifier(sourceIdentifier.applyValue({ args0 -> args0 }))
            .sourceVersion(sourceVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProjectSecondarySourceVersionArgs].
 */
@PulumiTagMarker
public class ProjectSecondarySourceVersionArgsBuilder internal constructor() {
    private var sourceIdentifier: Output<String>? = null

    private var sourceVersion: Output<String>? = null

    /**
     * @param value An identifier for a source in the build project.
     */
    @JvmName("wlmbueltjelbchcs")
    public suspend fun sourceIdentifier(`value`: Output<String>) {
        this.sourceIdentifier = value
    }

    /**
     * @param value The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
     */
    @JvmName("hsehmovaqxladrrw")
    public suspend fun sourceVersion(`value`: Output<String>) {
        this.sourceVersion = value
    }

    /**
     * @param value An identifier for a source in the build project.
     */
    @JvmName("ptkpweyiaxgroiel")
    public suspend fun sourceIdentifier(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceIdentifier = mapped
    }

    /**
     * @param value The source version for the corresponding source identifier. See [AWS docs](https://docs.aws.amazon.com/codebuild/latest/APIReference/API_ProjectSourceVersion.html#CodeBuild-Type-ProjectSourceVersion-sourceVersion) for more details.
     */
    @JvmName("pdslkknifxkqxcnr")
    public suspend fun sourceVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceVersion = mapped
    }

    internal fun build(): ProjectSecondarySourceVersionArgs = ProjectSecondarySourceVersionArgs(
        sourceIdentifier = sourceIdentifier ?: throw PulumiNullFieldException("sourceIdentifier"),
        sourceVersion = sourceVersion ?: throw PulumiNullFieldException("sourceVersion"),
    )
}
